/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ThreadSafe
public class URLSchemaContextResolver
implements AdvancedSchemaSourceProvider<InputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(URLSchemaContextResolver.class);
    @GuardedBy(value="this")
    private final ConcurrentMap<SourceIdentifier, SourceContext> availableSources = new ConcurrentHashMap<SourceIdentifier, SourceContext>();
    @GuardedBy(value="this")
    private YangSourceContext currentSourceContext;
    @GuardedBy(value="this")
    private Optional<SchemaContext> currentSchemaContext = Optional.absent();

    public synchronized ObjectRegistration<URL> registerSource(URL source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"Supplied source must not be null");
        InputStream yangStream = URLSchemaContextResolver.getInputStream(source);
        YangModelDependencyInfo modelInfo = YangModelDependencyInfo.fromInputStream(yangStream);
        SourceIdentifier identifier = SourceIdentifier.create((String)modelInfo.getName(), (Optional)Optional.of((Object)modelInfo.getFormattedRevision()));
        SourceContext sourceContext = new SourceContext(source, identifier, modelInfo);
        this.availableSources.putIfAbsent(identifier, sourceContext);
        return sourceContext;
    }

    public synchronized Optional<SchemaContext> getSchemaContext() {
        return this.currentSchemaContext;
    }

    public synchronized Optional<InputStream> getSchemaSource(SourceIdentifier key) {
        SourceContext ctx = (SourceContext)((Object)this.availableSources.get(key));
        if (ctx != null) {
            InputStream stream = URLSchemaContextResolver.getInputStream((URL)ctx.getInstance());
            return Optional.fromNullable((Object)stream);
        }
        return Optional.absent();
    }

    public Optional<InputStream> getSchemaSource(String name, Optional<String> version) {
        return this.getSchemaSource(SourceIdentifier.create((String)name, version));
    }

    private static InputStream getInputStream(URL source) {
        InputStream stream;
        try {
            stream = source.openStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Supplied stream: " + source + " is not available", e);
        }
        return stream;
    }

    private synchronized void removeSource(SourceContext sourceContext) {
        boolean removed = this.availableSources.remove(sourceContext.getIdentifier(), (Object)sourceContext);
        if (removed) {
            this.tryToUpdateSchemaContext();
        }
    }

    public synchronized Optional<SchemaContext> tryToUpdateSchemaContext() {
        if (this.availableSources.isEmpty()) {
            return Optional.absent();
        }
        ImmutableMap actualSources = ImmutableMap.copyOf(this.availableSources);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : actualSources.entrySet()) {
            builder.put(entry.getKey(), (Object)((SourceContext)((Object)entry.getValue())).getDependencyInfo());
        }
        ImmutableMap sourcesMap = builder.build();
        YangSourceContext yangSourceContext = YangSourceContext.createFrom((Map<SourceIdentifier, YangModelDependencyInfo>)sourcesMap, this);
        LOG.debug("Trying to create schema context from {}", (Object)sourcesMap.keySet());
        if (!yangSourceContext.getMissingDependencies().isEmpty()) {
            LOG.debug("Omitting {} because of unresolved dependencies", (Object)yangSourceContext.getMissingDependencies().keySet());
            LOG.debug("Missing model sources for {}", yangSourceContext.getMissingSources());
        }
        if (this.currentSourceContext == null || !yangSourceContext.getValidSources().equals(this.currentSourceContext.getValidSources())) {
            try {
                Collection<ByteSource> byteSources = yangSourceContext.getValidByteSources();
                YangParserImpl parser = YangParserImpl.getInstance();
                SchemaContext schemaContext = parser.parseSources(byteSources);
                this.currentSchemaContext = Optional.of((Object)schemaContext);
                this.currentSourceContext = yangSourceContext;
                return Optional.of((Object)schemaContext);
            }
            catch (Exception e) {
                LOG.error("Could not create schema context for {} ", yangSourceContext.getValidSources(), (Object)e);
                return Optional.absent();
            }
        }
        this.currentSourceContext = yangSourceContext;
        return Optional.absent();
    }

    private final class SourceContext
    extends AbstractObjectRegistration<URL>
    implements Identifiable<SourceIdentifier> {
        final SourceIdentifier identifier;
        final YangModelDependencyInfo dependencyInfo;

        public SourceContext(URL instance, SourceIdentifier identifier, YangModelDependencyInfo modelInfo) {
            super((Object)instance);
            this.identifier = identifier;
            this.dependencyInfo = modelInfo;
        }

        public SourceIdentifier getIdentifier() {
            return this.identifier;
        }

        protected void removeRegistration() {
            URLSchemaContextResolver.this.removeSource(this);
        }

        public YangModelDependencyInfo getDependencyInfo() {
            return this.dependencyInfo;
        }
    }
}

