/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.opendaylight.yangtools.antlrv4.code.gen.YangParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.impl.ParserListenerUtils;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;

public abstract class YangModelDependencyInfo {
    private final String name;
    private final String formattedRevision;
    private final Date revision;
    private final ImmutableSet<ModuleImport> submoduleIncludes;
    private final ImmutableSet<ModuleImport> moduleImports;
    private final ImmutableSet<ModuleImport> dependencies;

    YangModelDependencyInfo(String name, String formattedRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
        this.name = name;
        this.formattedRevision = formattedRevision;
        this.revision = formattedRevision == null ? null : QName.parseRevision((String)formattedRevision);
        this.moduleImports = imports;
        this.submoduleIncludes = includes;
        this.dependencies = ImmutableSet.builder().addAll(this.moduleImports).addAll(this.submoduleIncludes).build();
    }

    public ImmutableSet<ModuleImport> getDependencies() {
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getFormattedRevision() {
        return this.formattedRevision;
    }

    Date getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formattedRevision == null ? 0 : this.formattedRevision.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YangModelDependencyInfo)) {
            return false;
        }
        YangModelDependencyInfo other = (YangModelDependencyInfo)obj;
        if (this.formattedRevision == null ? other.formattedRevision != null : !this.formattedRevision.equals(other.formattedRevision)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static YangModelDependencyInfo fromAST(String name, ParserRuleContext tree) throws YangSyntaxErrorException {
        Optional<YangParser.Module_stmtContext> moduleCtx = ParserListenerUtils.getFirstContext(tree, YangParser.Module_stmtContext.class);
        if (moduleCtx.isPresent()) {
            return YangModelDependencyInfo.parseModuleContext((YangParser.Module_stmtContext)((Object)moduleCtx.get()));
        }
        Optional<YangParser.Submodule_stmtContext> submoduleCtx = ParserListenerUtils.getFirstContext(tree, YangParser.Submodule_stmtContext.class);
        if (submoduleCtx.isPresent()) {
            return YangModelDependencyInfo.parseSubmoduleContext((YangParser.Submodule_stmtContext)((Object)submoduleCtx.get()));
        }
        throw new YangSyntaxErrorException(name, 0, 0, "Unknown YANG text type");
    }

    public static YangModelDependencyInfo fromInputStream(InputStream yangStream) {
        YangParser.YangContext yangContext = YangParserImpl.parseStreamWithoutErrorListeners(yangStream);
        Optional<YangParser.Module_stmtContext> moduleCtx = ParserListenerUtils.getFirstContext(yangContext, YangParser.Module_stmtContext.class);
        if (moduleCtx.isPresent()) {
            return YangModelDependencyInfo.parseModuleContext((YangParser.Module_stmtContext)((Object)moduleCtx.get()));
        }
        Optional<YangParser.Submodule_stmtContext> submoduleCtx = ParserListenerUtils.getFirstContext(yangContext, YangParser.Submodule_stmtContext.class);
        if (submoduleCtx.isPresent()) {
            return YangModelDependencyInfo.parseSubmoduleContext((YangParser.Submodule_stmtContext)((Object)submoduleCtx.get()));
        }
        throw new IllegalArgumentException("Supplied stream is not valid yang file.");
    }

    private static YangModelDependencyInfo parseModuleContext(YangParser.Module_stmtContext module) {
        String name = ParserListenerUtils.getArgumentString(module);
        String latestRevision = YangModelDependencyInfo.getLatestRevision(module.revision_stmts());
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(module.linkage_stmts().import_stmt());
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(module.linkage_stmts().include_stmt());
        return new ModuleDependencyInfo(name, latestRevision, imports, includes);
    }

    private static ImmutableSet<ModuleImport> parseImports(List<YangParser.Import_stmtContext> importStatements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (YangParser.Import_stmtContext importStmt : importStatements) {
            String moduleName = ParserListenerUtils.getArgumentString(importStmt);
            Date revision = YangModelDependencyInfo.getRevision(importStmt.revision_date_stmt());
            builder.add((Object)new ModuleImportImpl(moduleName, revision));
        }
        return builder.build();
    }

    public static String getLatestRevision(YangParser.Revision_stmtsContext revisionStmts) {
        List revisions = revisionStmts.getRuleContexts(YangParser.Revision_stmtContext.class);
        String latestRevision = null;
        for (YangParser.Revision_stmtContext revisionStmt : revisions) {
            String currentRevision = ParserListenerUtils.getArgumentString(revisionStmt);
            if (latestRevision != null && latestRevision.compareTo(currentRevision) != -1) continue;
            latestRevision = currentRevision;
        }
        return latestRevision;
    }

    private static YangModelDependencyInfo parseSubmoduleContext(YangParser.Submodule_stmtContext submodule) {
        String name = ParserListenerUtils.getArgumentString(submodule);
        YangParser.Belongs_to_stmtContext belongsToStmt = submodule.submodule_header_stmts().belongs_to_stmt(0);
        String belongsTo = ParserListenerUtils.getArgumentString(belongsToStmt);
        String latestRevision = YangModelDependencyInfo.getLatestRevision(submodule.revision_stmts());
        ImmutableSet<ModuleImport> imports = YangModelDependencyInfo.parseImports(submodule.linkage_stmts().import_stmt());
        ImmutableSet<ModuleImport> includes = YangModelDependencyInfo.parseIncludes(submodule.linkage_stmts().include_stmt());
        return new SubmoduleDependencyInfo(name, latestRevision, belongsTo, imports, includes);
    }

    private static ImmutableSet<ModuleImport> parseIncludes(List<YangParser.Include_stmtContext> importStatements) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (YangParser.Include_stmtContext importStmt : importStatements) {
            String moduleName = ParserListenerUtils.getArgumentString(importStmt);
            Date revision = YangModelDependencyInfo.getRevision(importStmt.revision_date_stmt());
            builder.add((Object)new ModuleImportImpl(moduleName, revision));
        }
        return builder.build();
    }

    private static Date getRevision(YangParser.Revision_date_stmtContext revisionDateStmt) {
        if (revisionDateStmt == null) {
            return null;
        }
        String formatedDate = ParserListenerUtils.getArgumentString(revisionDateStmt);
        return QName.parseRevision((String)formatedDate);
    }

    private static final class ModuleImportImpl
    implements ModuleImport {
        private final Date revision;
        private final String name;

        public ModuleImportImpl(String moduleName, Date revision) {
            this.name = moduleName;
            this.revision = revision;
        }

        public String getModuleName() {
            return this.name;
        }

        public Date getRevision() {
            return this.revision;
        }

        public String getPrefix() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleImportImpl other = (ModuleImportImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
        }

        public String toString() {
            return "ModuleImportImpl [name=" + this.name + ", revision=" + QName.formattedRevision((Date)this.revision) + "]";
        }
    }

    public static final class SubmoduleDependencyInfo
    extends YangModelDependencyInfo {
        private final String belongsTo;

        private SubmoduleDependencyInfo(String name, String latestRevision, String belongsTo, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
            this.belongsTo = belongsTo;
        }

        public String getParentModule() {
            return this.belongsTo;
        }

        public String toString() {
            return "Submodule [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }

    public static final class ModuleDependencyInfo
    extends YangModelDependencyInfo {
        private ModuleDependencyInfo(String name, String latestRevision, ImmutableSet<ModuleImport> imports, ImmutableSet<ModuleImport> includes) {
            super(name, latestRevision, imports, includes);
        }

        public String toString() {
            return "Module [name=" + this.getName() + ", revision=" + this.getRevision() + ", dependencies=" + this.getDependencies() + "]";
        }
    }
}

