/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceContextResolver;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceFromCapabilitiesResolver;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceFromDependencyInfoResolver;

@Deprecated
@ThreadSafe
public class YangSourceContext
implements AdvancedSchemaSourceProvider<InputStream>,
Closeable,
Delegator<AdvancedSchemaSourceProvider<InputStream>> {
    private final ImmutableSet<SourceIdentifier> validSources;
    private final ImmutableSet<SourceIdentifier> missingSources;
    private final ImmutableMultimap<SourceIdentifier, ModuleImport> missingDependencies;
    private final AdvancedSchemaSourceProvider<InputStream> sourceProvider;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    YangSourceContext(ImmutableSet<SourceIdentifier> validSourcesSet, ImmutableSet<SourceIdentifier> missingSourcesSet, ImmutableMultimap<SourceIdentifier, ModuleImport> missingDependenciesMap, AdvancedSchemaSourceProvider<InputStream> sourceProvider) {
        this.validSources = (ImmutableSet)Preconditions.checkNotNull(validSourcesSet, (Object)"Valid source set must not be null");
        this.missingSources = (ImmutableSet)Preconditions.checkNotNull(missingSourcesSet, (Object)"Missing sources set must not be null");
        this.missingDependencies = (ImmutableMultimap)Preconditions.checkNotNull(missingDependenciesMap, (Object)"Missing dependencies map must not be null");
        this.sourceProvider = (AdvancedSchemaSourceProvider)Preconditions.checkNotNull(sourceProvider, (Object)"Missing sourceProvider");
    }

    public ImmutableSet<SourceIdentifier> getValidSources() {
        return this.validSources;
    }

    public ImmutableSet<SourceIdentifier> getMissingSources() {
        return this.missingSources;
    }

    public ImmutableMultimap<SourceIdentifier, ModuleImport> getMissingDependencies() {
        return this.missingDependencies;
    }

    public Optional<InputStream> getSchemaSource(String moduleName, Optional<String> revision) {
        return this.getSchemaSource(SourceIdentifier.create((String)moduleName, revision));
    }

    public Optional<InputStream> getSchemaSource(SourceIdentifier sourceIdentifier) {
        if (this.validSources.contains((Object)sourceIdentifier)) {
            return this.getDelegateChecked().getSchemaSource(sourceIdentifier);
        }
        return Optional.absent();
    }

    private AdvancedSchemaSourceProvider<InputStream> getDelegateChecked() {
        this.assertNotClosed();
        return this.sourceProvider;
    }

    public AdvancedSchemaSourceProvider<InputStream> getDelegate() {
        this.assertNotClosed();
        return this.sourceProvider;
    }

    private void assertNotClosed() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Instance already closed");
        }
    }

    @Override
    public void close() {
        this.isClosed.set(true);
    }

    public static YangSourceContext createFrom(Iterable<QName> capabilities, SchemaSourceProvider<InputStream> schemaSourceProvider) {
        YangSourceFromCapabilitiesResolver resolver = new YangSourceFromCapabilitiesResolver(capabilities, schemaSourceProvider);
        return ((YangSourceContextResolver)resolver).resolveContext();
    }

    public static YangSourceContext createFrom(Map<SourceIdentifier, YangModelDependencyInfo> moduleDependencies, AdvancedSchemaSourceProvider<InputStream> sourceProvider) {
        YangSourceFromDependencyInfoResolver resolver = new YangSourceFromDependencyInfoResolver(moduleDependencies, sourceProvider);
        return resolver.resolveContext();
    }

    @Deprecated
    public List<InputStream> getValidInputStreams() {
        return this.getValidInputStreamsInternal();
    }

    private List<InputStream> getValidInputStreamsInternal() {
        this.assertNotClosed();
        HashSet<SourceIdentifier> sourcesToLoad = new HashSet<SourceIdentifier>();
        sourcesToLoad.addAll((Collection<SourceIdentifier>)this.getValidSources());
        for (SourceIdentifier source : this.getValidSources()) {
            if (source.getRevision() == null) continue;
            SourceIdentifier sourceWithoutRevision = SourceIdentifier.create((String)source.getName(), (Optional)Optional.absent());
            sourcesToLoad.remove(sourceWithoutRevision);
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (SourceIdentifier sourceIdentifier : sourcesToLoad) {
            Optional source = this.sourceProvider.getSchemaSource(sourceIdentifier);
            ret.add(source.get());
        }
        return ret.build();
    }

    public Collection<ByteSource> getValidByteSources() throws IOException {
        List<InputStream> yangModelStreams = this.getValidInputStreamsInternal();
        return BuilderUtils.streamsToByteSources(yangModelStreams);
    }

    @Deprecated
    public static List<InputStream> getValidInputStreams(YangSourceContext context) {
        return context.getValidInputStreams();
    }
}

