/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.impl.util.YangSourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@NotThreadSafe
public abstract class YangSourceContextResolver {
    private static final Logger LOG = LoggerFactory.getLogger(YangSourceContextResolver.class);
    private final Map<SourceIdentifier, ResolutionState> alreadyProcessed = new HashMap<SourceIdentifier, ResolutionState>();
    private final ImmutableSet.Builder<SourceIdentifier> missingSources = ImmutableSet.builder();
    private final ImmutableMultimap.Builder<SourceIdentifier, ModuleImport> missingDependencies = ImmutableMultimap.builder();
    private final ImmutableSet.Builder<SourceIdentifier> validSources = ImmutableSet.builder();
    private final AdvancedSchemaSourceProvider<InputStream> sourceProvider;

    public YangSourceContextResolver(AdvancedSchemaSourceProvider<InputStream> sourceProvider) {
        this.sourceProvider = (AdvancedSchemaSourceProvider)Preconditions.checkNotNull(sourceProvider, (Object)"Missing sourceProvider");
    }

    public abstract YangSourceContext resolveContext();

    abstract Optional<YangModelDependencyInfo> getDependencyInfo(SourceIdentifier var1);

    public AdvancedSchemaSourceProvider<InputStream> getSourceProvider() {
        return this.sourceProvider;
    }

    public final ResolutionState resolveSource(String name, Optional<String> formattedRevision) {
        return this.resolveSource(new SourceIdentifier(name, formattedRevision));
    }

    public final ResolutionState resolveSource(SourceIdentifier identifier) {
        ResolutionState potentialState;
        block5: {
            if (this.alreadyProcessed.containsKey(identifier)) {
                return this.alreadyProcessed.get(identifier);
            }
            LOG.trace("Resolving source:\u00a0{}", (Object)identifier);
            potentialState = ResolutionState.EVERYTHING_OK;
            try {
                Optional<YangModelDependencyInfo> potentialInfo = this.getDependencyInfo(identifier);
                if (potentialInfo.isPresent()) {
                    YangModelDependencyInfo info = (YangModelDependencyInfo)potentialInfo.get();
                    this.checkValidSource(identifier, info);
                    for (ModuleImport dependency : info.getDependencies()) {
                        LOG.trace("Source: {} Resolving dependency: {}", (Object)identifier, (Object)dependency);
                        ResolutionState dependencyState = this.resolveDependency(dependency);
                        if (dependencyState == ResolutionState.EVERYTHING_OK) continue;
                        potentialState = ResolutionState.MISSING_DEPENDENCY;
                        this.missingDependencies.put((Object)identifier, (Object)dependency);
                    }
                    break block5;
                }
                this.missingSources.add((Object)identifier);
                return ResolutionState.MISSING_SOURCE;
            }
            catch (Exception e) {
                potentialState = ResolutionState.OTHER_ERROR;
            }
        }
        this.updateResolutionState(identifier, potentialState);
        return potentialState;
    }

    private boolean checkValidSource(SourceIdentifier identifier, YangModelDependencyInfo info) {
        if (!identifier.getName().equals(info.getName())) {
            LOG.warn("Incorrect model returned. Identifier name was: {}, source contained: {}", (Object)identifier.getName(), (Object)info.getName());
            throw new IllegalStateException("Incorrect source was returned");
        }
        return true;
    }

    private void updateResolutionState(SourceIdentifier identifier, ResolutionState potentialState) {
        this.alreadyProcessed.put(identifier, potentialState);
        switch (potentialState) {
            case MISSING_SOURCE: {
                this.missingSources.add((Object)identifier);
                break;
            }
            case EVERYTHING_OK: {
                this.validSources.add((Object)identifier);
                break;
            }
        }
    }

    private ResolutionState resolveDependency(ModuleImport dependency) {
        String name = dependency.getModuleName();
        Optional formattedRevision = Optional.fromNullable((Object)QName.formattedRevision((Date)dependency.getRevision()));
        return this.resolveSource(new SourceIdentifier(name, formattedRevision));
    }

    protected YangSourceContext createSourceContext() {
        ImmutableSet missingSourcesSet = this.missingSources.build();
        ImmutableMultimap missingDependenciesMap = this.missingDependencies.build();
        ImmutableSet validSourcesSet = this.validSources.build();
        return new YangSourceContext((ImmutableSet<SourceIdentifier>)validSourcesSet, (ImmutableSet<SourceIdentifier>)missingSourcesSet, (ImmutableMultimap<SourceIdentifier, ModuleImport>)missingDependenciesMap, this.sourceProvider);
    }

    public static enum ResolutionState {
        MISSING_SOURCE,
        MISSING_DEPENDENCY,
        OTHER_ERROR,
        EVERYTHING_OK;

    }
}

