/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.impl.util.YangModelDependencyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyResolver.class);
    private final Collection<SourceIdentifier> resolvedSources;
    private final Collection<SourceIdentifier> unresolvedSources;
    private final Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports;

    public DependencyResolver(Collection<SourceIdentifier> resolvedSources, Collection<SourceIdentifier> unresolvedSources, Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports) {
        this.resolvedSources = (Collection)Preconditions.checkNotNull(resolvedSources);
        this.unresolvedSources = (Collection)Preconditions.checkNotNull(unresolvedSources);
        this.unsatisfiedImports = (Multimap)Preconditions.checkNotNull(unsatisfiedImports);
    }

    private static SourceIdentifier findWildcard(Iterable<SourceIdentifier> haystack, String needle) {
        for (SourceIdentifier r : haystack) {
            if (!r.getName().equals(needle)) continue;
            return r;
        }
        return null;
    }

    private static boolean isKnown(Collection<SourceIdentifier> haystack, ModuleImport mi) {
        String rev = mi.getRevision() != null ? QName.formattedRevision((Date)mi.getRevision()) : null;
        SourceIdentifier msi = SourceIdentifier.create((String)mi.getModuleName(), (Optional)Optional.fromNullable((Object)rev));
        if (haystack.contains(msi)) {
            return true;
        }
        return rev == null && DependencyResolver.findWildcard(haystack, mi.getModuleName()) != null;
    }

    public static DependencyResolver create(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        boolean progress;
        ArrayList<SourceIdentifier> resolved = new ArrayList<SourceIdentifier>(depInfo.size());
        ArrayList<SourceIdentifier> pending = new ArrayList<SourceIdentifier>(depInfo.keySet());
        HashMap submodules = Maps.newHashMap();
        do {
            progress = false;
            Iterator it = pending.iterator();
            while (it.hasNext()) {
                SourceIdentifier id = (SourceIdentifier)it.next();
                YangModelDependencyInfo dep = depInfo.get(id);
                boolean okay = true;
                ImmutableSet<ModuleImport> dependencies = dep.getDependencies();
                if (dep instanceof YangModelDependencyInfo.SubmoduleDependencyInfo) {
                    String parent = ((YangModelDependencyInfo.SubmoduleDependencyInfo)dep).getParentModule();
                    submodules.put(id, new BelongsToDependency(parent));
                }
                for (ModuleImport mi : dependencies) {
                    if (DependencyResolver.isKnown(resolved, mi)) continue;
                    LOG.debug("Source {} is missing import {}", (Object)id, (Object)mi);
                    okay = false;
                    break;
                }
                if (!okay) continue;
                LOG.debug("Resolved source {}", (Object)id);
                resolved.add(id);
                it.remove();
                progress = true;
            }
        } while (progress);
        for (Map.Entry submodule : submodules.entrySet()) {
            BelongsToDependency belongs = (BelongsToDependency)submodule.getValue();
            SourceIdentifier sourceIdentifier = (SourceIdentifier)submodule.getKey();
            if (DependencyResolver.isKnown(resolved, belongs)) continue;
            LOG.debug("Source {} is missing parent {}", (Object)sourceIdentifier, (Object)belongs);
            pending.add(sourceIdentifier);
            resolved.remove(sourceIdentifier);
        }
        if (!pending.isEmpty()) {
            ArrayListMultimap imports = ArrayListMultimap.create();
            for (SourceIdentifier id : pending) {
                YangModelDependencyInfo dep = depInfo.get(id);
                for (ModuleImport mi : dep.getDependencies()) {
                    if (DependencyResolver.isKnown(pending, mi) || DependencyResolver.isKnown(resolved, mi)) continue;
                    imports.put((Object)id, (Object)mi);
                }
            }
            return new DependencyResolver(resolved, pending, (Multimap<SourceIdentifier, ModuleImport>)imports);
        }
        return new DependencyResolver(resolved, Collections.emptyList(), (Multimap<SourceIdentifier, ModuleImport>)ImmutableMultimap.of());
    }

    Collection<SourceIdentifier> getResolvedSources() {
        return this.resolvedSources;
    }

    Collection<SourceIdentifier> getUnresolvedSources() {
        return this.unresolvedSources;
    }

    Multimap<SourceIdentifier, ModuleImport> getUnsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    private static class BelongsToDependency
    implements ModuleImport {
        private final String parent;

        public BelongsToDependency(String parent) {
            this.parent = parent;
        }

        public String getModuleName() {
            return this.parent;
        }

        public Date getRevision() {
            return null;
        }

        public String getPrefix() {
            return null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.parent).toString();
        }
    }
}

