/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;
import org.opendaylight.yangtools.util.concurrent.ReflectiveExceptionMapper;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.builder.impl.BuilderUtils;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleBuilder;
import org.opendaylight.yangtools.yang.parser.impl.YangParserImpl;
import org.opendaylight.yangtools.yang.parser.impl.YangParserListenerImpl;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.util.ASTSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SharedSchemaContextFactory
implements SchemaContextFactory {
    private static final ExceptionMapper<SchemaResolutionException> MAPPER = ReflectiveExceptionMapper.create((String)"resolve sources", SchemaResolutionException.class);
    private static final Logger LOG = LoggerFactory.getLogger(SharedSchemaContextFactory.class);
    private final Function<SourceIdentifier, ListenableFuture<ASTSchemaSource>> requestSources = new Function<SourceIdentifier, ListenableFuture<ASTSchemaSource>>(){

        public ListenableFuture<ASTSchemaSource> apply(SourceIdentifier input) {
            return SharedSchemaContextFactory.this.repository.getSchemaSource(input, ASTSchemaSource.class);
        }
    };
    private final Cache<Collection<SourceIdentifier>, SchemaContext> cache = CacheBuilder.newBuilder().weakValues().build();
    private final AsyncFunction<List<ASTSchemaSource>, SchemaContext> assembleSources = new AsyncFunction<List<ASTSchemaSource>, SchemaContext>(){

        public ListenableFuture<SchemaContext> apply(List<ASTSchemaSource> sources) throws SchemaResolutionException {
            ImmutableMap srcs = Maps.uniqueIndex(sources, ASTSchemaSource.GET_IDENTIFIER);
            Map deps = Maps.transformValues((Map)srcs, ASTSchemaSource.GET_DEPINFO);
            LOG.debug("Resolving dependency reactor {}", (Object)deps);
            DependencyResolver res = DependencyResolver.create(deps);
            if (!res.getUnresolvedSources().isEmpty()) {
                LOG.debug("Omitting models {} due to unsatisfied imports {}", res.getUnresolvedSources(), res.getUnsatisfiedImports());
                throw new SchemaResolutionException("Failed to resolve required models", res.getResolvedSources(), res.getUnsatisfiedImports());
            }
            Map asts = Maps.transformValues((Map)srcs, ASTSchemaSource.GET_AST);
            Map<String, NavigableMap<Date, URI>> namespaceContext = BuilderUtils.createYangNamespaceContext(asts.values(), (Optional<SchemaContext>)Optional.absent());
            ParseTreeWalker walker = new ParseTreeWalker();
            LinkedHashMap sourceToBuilder = new LinkedHashMap();
            for (Map.Entry entry : asts.entrySet()) {
                ModuleBuilder moduleBuilder = YangParserListenerImpl.create(namespaceContext, ((SourceIdentifier)entry.getKey()).getName(), walker, (ParseTree)entry.getValue()).getModuleBuilder();
                moduleBuilder.setSource(((ASTSchemaSource)srcs.get(entry.getKey())).getYangText());
                sourceToBuilder.put(entry.getKey(), moduleBuilder);
            }
            LOG.debug("Modules ready for integration");
            YangParserImpl parser = YangParserImpl.getInstance();
            Collection<Module> modules = parser.buildModules(sourceToBuilder.values());
            LOG.debug("Integrated cross-references modules");
            return Futures.immediateCheckedFuture((Object)parser.assembleContext(modules));
        }
    };
    private final SharedSchemaRepository repository;
    private final SchemaSourceFilter filter;

    public SharedSchemaContextFactory(SharedSchemaRepository repository, SchemaSourceFilter filter) {
        this.repository = (SharedSchemaRepository)((Object)Preconditions.checkNotNull((Object)((Object)repository)));
        this.filter = (SchemaSourceFilter)Preconditions.checkNotNull((Object)filter);
    }

    public CheckedFuture<SchemaContext, SchemaResolutionException> createSchemaContext(Collection<SourceIdentifier> requiredSources) {
        final List<SourceIdentifier> uniqueSourceIdentifiers = this.deDuplicateSources(requiredSources);
        SchemaContext existing = (SchemaContext)this.cache.getIfPresent(uniqueSourceIdentifiers);
        if (existing != null) {
            LOG.debug("Returning cached context {}", (Object)existing);
            return Futures.immediateCheckedFuture((Object)existing);
        }
        ListenableFuture sf = Futures.allAsList((Iterable)Collections2.transform(uniqueSourceIdentifiers, this.requestSources));
        sf = Futures.transform((ListenableFuture)sf, (Function)new SourceIdMismatchDetector(uniqueSourceIdentifiers));
        ListenableFuture cf = Futures.transform((ListenableFuture)sf, this.assembleSources);
        Futures.addCallback((ListenableFuture)cf, (FutureCallback)new FutureCallback<SchemaContext>(){

            public void onSuccess(SchemaContext result) {
                SharedSchemaContextFactory.this.cache.put((Object)uniqueSourceIdentifiers, (Object)result);
            }

            public void onFailure(Throwable t) {
                LOG.debug("Failed to assemble sources", t);
            }
        });
        return Futures.makeChecked((ListenableFuture)cf, MAPPER);
    }

    private List<SourceIdentifier> deDuplicateSources(final Collection<SourceIdentifier> requiredSources) {
        Set uniqueSourceIdentifiers = Collections.unmodifiableSet(Sets.newLinkedHashSet(requiredSources));
        if (uniqueSourceIdentifiers.size() != requiredSources.size()) {
            LOG.warn("Duplicate sources requested for schema context, removed duplicate sources: {}", (Object)Collections2.filter(uniqueSourceIdentifiers, (Predicate)new Predicate<SourceIdentifier>(){

                public boolean apply(@Nullable SourceIdentifier input) {
                    return Iterables.frequency((Iterable)requiredSources, (Object)input) > 1;
                }
            }));
        }
        return Lists.newArrayList(uniqueSourceIdentifiers);
    }

    private static final class SourceIdMismatchDetector
    implements Function<List<ASTSchemaSource>, List<ASTSchemaSource>> {
        private final List<SourceIdentifier> sourceIdentifiers;

        public SourceIdMismatchDetector(List<SourceIdentifier> sourceIdentifiers) {
            this.sourceIdentifiers = sourceIdentifiers;
        }

        public List<ASTSchemaSource> apply(List<ASTSchemaSource> input) {
            LinkedHashMap filtered = Maps.newLinkedHashMap();
            for (int i = 0; i < input.size(); ++i) {
                ASTSchemaSource astSchemaSource;
                SourceIdentifier realSId;
                SourceIdentifier expectedSId = this.sourceIdentifiers.get(i);
                if (!expectedSId.equals((Object)(realSId = (astSchemaSource = input.get(i)).getIdentifier()))) {
                    LOG.warn("Source identifier mismatch for module \"{}\", requested as {} but actually is {}. Using actual id", new Object[]{expectedSId.getName(), expectedSId, realSId});
                }
                if (filtered.containsKey(realSId)) {
                    LOG.warn("Duplicate source for module {} detected in reactor", (Object)realSId);
                }
                filtered.put(realSId, astSchemaSource);
            }
            return Lists.newArrayList(filtered.values());
        }
    }
}

