/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.util.AbstractSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaContextFactory;

@Beta
public final class SharedSchemaRepository
extends AbstractSchemaRepository
implements Identifiable<String> {
    private final LoadingCache<SchemaSourceFilter, SchemaContextFactory> cache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<SchemaSourceFilter, SchemaContextFactory>(){

        public SchemaContextFactory load(SchemaSourceFilter key) {
            return new SharedSchemaContextFactory(SharedSchemaRepository.this, key);
        }
    });
    private final String id;

    public SharedSchemaRepository(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public String getIdentifier() {
        return this.id;
    }

    public SchemaContextFactory createSchemaContextFactory(SchemaSourceFilter filter) {
        return (SchemaContextFactory)this.cache.getUnchecked((Object)filter);
    }

    public String toString() {
        return "SchemaRepository: " + this.id;
    }
}

