/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.InMemorySchemaSourceCache;
import org.opendaylight.yangtools.yang.parser.repo.AbstractURLRegistration;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.URLRegistration;
import org.opendaylight.yangtools.yang.parser.util.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.util.TextToASTTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class URLSchemaContextResolver
implements AutoCloseable,
SchemaSourceProvider<YangTextSchemaSource> {
    private static final Logger LOG = LoggerFactory.getLogger(URLSchemaContextResolver.class);
    private final Collection<SourceIdentifier> requiredSources = new ConcurrentLinkedDeque<SourceIdentifier>();
    private final Multimap<SourceIdentifier, YangTextSchemaSource> texts = ArrayListMultimap.create();
    private final AtomicReference<Optional<SchemaContext>> currentSchemaContext = new AtomicReference<Optional>(Optional.absent());
    private final InMemorySchemaSourceCache<ASTSchemaSource> cache;
    private final SchemaListenerRegistration transReg;
    private final SchemaSourceRegistry registry;
    private final SchemaRepository repository;
    private volatile Object version;
    private volatile Object contextVersion = this.version = new Object();

    private URLSchemaContextResolver(SchemaRepository repository, SchemaSourceRegistry registry) {
        this.repository = (SchemaRepository)Preconditions.checkNotNull((Object)repository);
        this.registry = (SchemaSourceRegistry)Preconditions.checkNotNull((Object)registry);
        TextToASTTransformer t = TextToASTTransformer.create(repository, registry);
        this.transReg = registry.registerSchemaSourceListener((SchemaSourceListener)t);
        this.cache = InMemorySchemaSourceCache.createSoftCache((SchemaSourceRegistry)registry, ASTSchemaSource.class);
    }

    public static URLSchemaContextResolver create(String name) {
        SharedSchemaRepository sharedRepo = new SharedSchemaRepository(name);
        return new URLSchemaContextResolver((SchemaRepository)sharedRepo, (SchemaSourceRegistry)sharedRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLRegistration registerSource(final URL url) throws SchemaSourceException, IOException, YangSyntaxErrorException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Supplied URL must not be null");
        SourceIdentifier guessedId = new SourceIdentifier(url.getFile(), Optional.absent());
        final YangTextSchemaSource text = new YangTextSchemaSource(guessedId){

            public InputStream openStream() throws IOException {
                return url.openStream();
            }

            protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
                return toStringHelper.add("url", (Object)url);
            }
        };
        ASTSchemaSource ast = (ASTSchemaSource)TextToASTTransformer.TRANSFORMATION.apply(text).checkedGet();
        LOG.trace("Resolved URL {} to source {}", (Object)url, (Object)ast);
        final SourceIdentifier resolvedId = ast.getIdentifier();
        URLSchemaContextResolver uRLSchemaContextResolver = this;
        synchronized (uRLSchemaContextResolver) {
            this.texts.put((Object)resolvedId, (Object)text);
            LOG.debug("Populated {} with text", (Object)resolvedId);
            final SchemaSourceRegistration reg = this.registry.registerSchemaSource((SchemaSourceProvider)this, PotentialSchemaSource.create((SourceIdentifier)resolvedId, YangTextSchemaSource.class, (int)PotentialSchemaSource.Costs.IMMEDIATE.getValue()));
            this.requiredSources.add(resolvedId);
            this.cache.schemaSourceEncountered((SchemaSourceRepresentation)ast);
            LOG.debug("Added source {} to schema context requirements", (Object)resolvedId);
            this.version = new Object();
            return new AbstractURLRegistration(text){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void removeRegistration() {
                    URLSchemaContextResolver uRLSchemaContextResolver = URLSchemaContextResolver.this;
                    synchronized (uRLSchemaContextResolver) {
                        URLSchemaContextResolver.this.requiredSources.remove(resolvedId);
                        LOG.trace("Removed source {} from schema context requirements", (Object)resolvedId);
                        URLSchemaContextResolver.this.version = new Object();
                        reg.close();
                        URLSchemaContextResolver.this.texts.remove((Object)resolvedId, (Object)text);
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SchemaContext> getSchemaContext() {
        Optional sc;
        SchemaContextFactory factory = this.repository.createSchemaContextFactory(SchemaSourceFilter.ALWAYS_ACCEPT);
        while (true) {
            Object sources;
            Object v;
            Object cv = this.contextVersion;
            sc = this.currentSchemaContext.get();
            if (this.version == cv) {
                return sc;
            }
            if (cv != this.contextVersion) continue;
            do {
                v = this.version;
                sources = ImmutableSet.copyOf(this.requiredSources);
            } while (v != this.version);
            while (true) {
                CheckedFuture f = factory.createSchemaContext((Collection)sources);
                try {
                    sc = Optional.of((Object)f.checkedGet());
                }
                catch (SchemaResolutionException e) {
                    LOG.debug("Failed to fully assemble schema context for {}", sources, (Object)e);
                    sources = e.getResolvedSources();
                    continue;
                }
                break;
            }
            LOG.debug("Resolved schema context for {}", sources);
            URLSchemaContextResolver uRLSchemaContextResolver = this;
            synchronized (uRLSchemaContextResolver) {
                if (this.contextVersion == cv) {
                    this.currentSchemaContext.set((Optional<SchemaContext>)sc);
                    this.contextVersion = v;
                }
            }
            if (this.version != v) break;
        }
        return sc;
    }

    public synchronized CheckedFuture<YangTextSchemaSource, SchemaSourceException> getSource(SourceIdentifier sourceIdentifier) {
        Collection ret = this.texts.get((Object)sourceIdentifier);
        LOG.debug("Lookup {} result {}", (Object)sourceIdentifier, (Object)ret);
        if (ret.isEmpty()) {
            return Futures.immediateFailedCheckedFuture((Exception)new MissingSchemaSourceException("URL for " + sourceIdentifier + " not registered", sourceIdentifier));
        }
        return Futures.immediateCheckedFuture(ret.iterator().next());
    }

    @Override
    public void close() {
        this.transReg.close();
    }
}

