/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

public abstract class AbstractDeclaredStatement<A>
implements DeclaredStatement<A> {
    private final A argument;
    private final String rawArgument;
    private final ImmutableList<? extends DeclaredStatement<?>> substatements;
    private final StatementDefinition definition;
    private final StatementSource source;

    protected AbstractDeclaredStatement(StmtContext<A, ?, ?> context) {
        this.rawArgument = context.rawStatementArgument();
        this.argument = context.getStatementArgument();
        this.source = context.getStatementSource();
        this.definition = context.getPublicDefinition();
        this.substatements = FluentIterable.from(context.declaredSubstatements()).transform(StmtContextUtils.buildDeclared()).toList();
    }

    protected final <S extends DeclaredStatement<?>> S firstDeclared(Class<S> type) {
        return (S)((DeclaredStatement)type.cast(Iterables.find(this.substatements, (Predicate)Predicates.instanceOf(type))));
    }

    public String rawArgument() {
        return this.rawArgument;
    }

    public A argument() {
        return this.argument;
    }

    public StatementDefinition statementDefinition() {
        return this.definition;
    }

    public Collection<? extends DeclaredStatement<?>> declaredSubstatements() {
        return this.substatements;
    }

    public StatementSource getStatementSource() {
        return this.source;
    }

    protected final <S extends DeclaredStatement<?>> Collection<? extends S> allDeclared(Class<S> type) {
        return (Collection)Collection.class.cast(Collections2.filter(this.substatements, (Predicate)Predicates.instanceOf(type)));
    }
}

