/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public abstract class AbstractStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
implements StatementDefinition,
StatementFactory<A, D, E>,
StatementSupport<A, D, E> {
    private final StatementDefinition type;

    protected AbstractStatementSupport(StatementDefinition publicDefinition) {
        Preconditions.checkArgument((publicDefinition != this ? 1 : 0) != 0);
        this.type = (StatementDefinition)Preconditions.checkNotNull((Object)publicDefinition);
    }

    public final QName getStatementName() {
        return this.type.getStatementName();
    }

    public final QName getArgumentName() {
        return this.type.getArgumentName();
    }

    public final Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.type.getDeclaredRepresentationClass();
    }

    public final Class<? extends DeclaredStatement<?>> getEffectiveRepresentationClass() {
        return this.type.getEffectiveRepresentationClass();
    }

    @Override
    public final StatementDefinition getPublicView() {
        return this.type;
    }

    @Override
    public abstract A parseArgumentValue(StmtContext<?, ?, ?> var1, String var2) throws SourceException;

    @Override
    public void onStatementAdded(StmtContext.Mutable<A, D, E> stmt) {
    }

    @Override
    public void onLinkageDeclared(StmtContext.Mutable<A, D, E> stmt) throws SourceException {
    }

    @Override
    public void onStatementDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) throws SourceException {
    }

    @Override
    public void onFullDefinitionDeclared(StmtContext.Mutable<A, D, E> stmt) throws SourceException {
    }
}

