/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;

public abstract class NamespaceBehaviour<K, V, N extends IdentifierNamespace<K, V>>
implements Identifiable<Class<N>> {
    private final Class<N> identifier;

    protected NamespaceBehaviour(Class<N> identifier) {
        this.identifier = (Class)Preconditions.checkNotNull(identifier);
    }

    @Nonnull
    public static <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> global(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.GLOBAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> sourceLocal(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.SOURCE_LOCAL_SPECIAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> treeScoped(Class<N> identifier) {
        return new TreeScoped(identifier);
    }

    public abstract V getFrom(NamespaceStorageNode var1, K var2);

    public abstract void addTo(NamespaceStorageNode var1, K var2, V var3);

    public Class<N> getIdentifier() {
        return this.identifier;
    }

    protected final V getFromLocalStorage(NamespaceStorageNode storage, K key) {
        return storage.getFromLocalStorage(this.getIdentifier(), key);
    }

    protected final void addToStorage(NamespaceStorageNode storage, K key, V value) {
        storage.addToLocalStorage(this.getIdentifier(), key, value);
    }

    static class TreeScoped<K, V, N extends IdentifierNamespace<K, V>>
    extends NamespaceBehaviour<K, V, N> {
        public TreeScoped(Class<N> identifier) {
            super(identifier);
        }

        @Override
        public V getFrom(NamespaceStorageNode storage, K key) {
            for (NamespaceStorageNode current = storage; current != null; current = current.getParentNamespaceStorage()) {
                Object val = this.getFromLocalStorage(current, key);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public void addTo(NamespaceStorageNode storage, K key, V value) {
            this.addToStorage(storage, key, value);
        }
    }

    static class StorageSpecific<K, V, N extends IdentifierNamespace<K, V>>
    extends NamespaceBehaviour<K, V, N> {
        StorageNodeType storageType;

        public StorageSpecific(Class<N> identifier, StorageNodeType type) {
            super(identifier);
            this.storageType = (StorageNodeType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        @Override
        public V getFrom(NamespaceStorageNode storage, K key) {
            NamespaceStorageNode current = storage;
            while (current.getStorageNodeType() != this.storageType) {
                current = current.getParentNamespaceStorage();
            }
            return this.getFromLocalStorage(current, key);
        }

        @Override
        public void addTo(NamespaceStorageNode storage, K key, V value) {
            NamespaceStorageNode current = storage;
            while (current.getStorageNodeType() != this.storageType) {
                current = current.getParentNamespaceStorage();
            }
            this.addToStorage(current, key, value);
        }
    }

    public static interface NamespaceStorageNode {
        public StorageNodeType getStorageNodeType();

        @Nullable
        public NamespaceStorageNode getParentNamespaceStorage();

        @Nullable
        public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> var1, K var2);

        @Nullable
        public <K, V, N extends IdentifierNamespace<K, V>> void addToLocalStorage(Class<N> var1, K var2, V var3);
    }

    public static interface Registry {
        public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> var1);
    }

    public static enum StorageNodeType {
        GLOBAL,
        SOURCE_LOCAL_SPECIAL,
        STATEMENT_LOCAL;

    }
}

