/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceNotAvailableException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;

public final class StatementSupportBundle
implements Immutable,
NamespaceBehaviour.Registry {
    private static final StatementSupportBundle EMPTY = new StatementSupportBundle(null, ImmutableMap.of(), ImmutableMap.of());
    private final StatementSupportBundle parent;
    private final ImmutableMap<QName, StatementSupport<?, ?, ?>> definitions;
    private final ImmutableMap<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaceDefinitions;

    private StatementSupportBundle(StatementSupportBundle parent, ImmutableMap<QName, StatementSupport<?, ?, ?>> statements, ImmutableMap<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaces) {
        this.parent = parent;
        this.definitions = statements;
        this.namespaceDefinitions = namespaces;
    }

    public ImmutableMap<QName, StatementSupport<?, ?, ?>> getDefinitions() {
        return this.definitions;
    }

    public static Builder builder() {
        return new Builder(EMPTY);
    }

    public static Builder derivedFrom(StatementSupportBundle parent) {
        return new Builder(parent);
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> namespace) throws NamespaceNotAvailableException {
        NamespaceBehaviour potential = (NamespaceBehaviour)this.namespaceDefinitions.get(namespace);
        if (potential != null) {
            Preconditions.checkState((boolean)namespace.equals(potential.getIdentifier()));
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getNamespaceBehaviour(namespace);
        }
        return null;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> boolean hasNamespaceBehaviour(Class<N> namespace) {
        if (this.namespaceDefinitions.containsKey(namespace)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasNamespaceBehaviour(namespace);
        }
        return false;
    }

    public StatementSupport<?, ?, ?> getStatementDefinition(QName stmtName) {
        StatementSupport potential = (StatementSupport)this.definitions.get((Object)stmtName);
        if (potential != null) {
            return potential;
        }
        if (this.parent != null) {
            return this.parent.getStatementDefinition(stmtName);
        }
        return null;
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<StatementSupportBundle> {
        private final StatementSupportBundle parent;
        private final Map<QName, StatementSupport<?, ?, ?>> statements = new HashMap();
        private final Map<Class<?>, NamespaceBehaviour<?, ?, ?>> namespaces = new HashMap();

        Builder(StatementSupportBundle parent) {
            this.parent = parent;
        }

        public Builder addSupport(StatementSupport<?, ?, ?> definition) {
            QName identifier = definition.getStatementName();
            Preconditions.checkState((!this.statements.containsKey(identifier) ? 1 : 0) != 0, (String)"Statement %s already defined.", (Object[])new Object[]{identifier});
            Preconditions.checkState((this.parent.getStatementDefinition(identifier) == null ? 1 : 0) != 0, (String)"Statement %s already defined.", (Object[])new Object[]{identifier});
            this.statements.put(identifier, definition);
            return this;
        }

        public <K, V, N extends IdentifierNamespace<K, V>> Builder addSupport(NamespaceBehaviour<K, V, N> namespaceSupport) {
            Object identifier = namespaceSupport.getIdentifier();
            Preconditions.checkState((!this.namespaces.containsKey(identifier) ? 1 : 0) != 0);
            Preconditions.checkState((!this.parent.hasNamespaceBehaviour(identifier) ? 1 : 0) != 0);
            this.namespaces.put((Class<?>)identifier, namespaceSupport);
            return this;
        }

        public StatementSupportBundle build() {
            return new StatementSupportBundle(this.parent, ImmutableMap.copyOf(this.statements), ImmutableMap.copyOf(this.namespaces));
        }
    }
}

