/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Function;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public final class StmtContextUtils {
    private static final Function<StmtContext<?, ?, ?>, DeclaredStatement<?>> BUILD_DECLARED = new Function<StmtContext<?, ?, ?>, DeclaredStatement<?>>(){

        public DeclaredStatement<?> apply(StmtContext<?, ?, ?> input) {
            return input.buildDeclared();
        }
    };
    private static final Function<StmtContext<?, ?, ?>, EffectiveStatement<?, ?>> BUILD_EFFECTIVE = new Function<StmtContext<?, ?, ?>, EffectiveStatement<?, ?>>(){

        public EffectiveStatement<?, ?> apply(StmtContext<?, ?, ?> input) {
            return input.buildEffective();
        }
    };

    private StmtContextUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <D extends DeclaredStatement<?>> Function<StmtContext<?, ? extends D, ?>, D> buildDeclared() {
        return (Function)Function.class.cast(BUILD_DECLARED);
    }

    public static final <E extends EffectiveStatement<?, ?>> Function<StmtContext<?, ?, ? extends E>, E> buildEffective() {
        return (Function)Function.class.cast(BUILD_EFFECTIVE);
    }

    public static final <AT, DT extends DeclaredStatement<AT>> AT firstAttributeOf(Iterable<? extends StmtContext<?, ?, ?>> contexts, Class<DT> declaredType) {
        for (StmtContext<?, ?, ?> ctx : contexts) {
            if (!StmtContextUtils.producesDeclared(ctx, declaredType)) continue;
            return (AT)ctx.getStatementArgument();
        }
        return null;
    }

    public static final <AT, DT extends DeclaredStatement<AT>> AT firstAttributeOf(StmtContext<?, ?, ?> ctx, Class<DT> declaredType) {
        if (StmtContextUtils.producesDeclared(ctx, declaredType)) {
            return (AT)ctx.getStatementArgument();
        }
        return null;
    }

    public static final <DT extends DeclaredStatement<?>> StmtContext<?, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<DT> declaredType) {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = stmtContext.declaredSubstatements();
        for (StmtContext stmtContext2 : declaredSubstatements) {
            if (!StmtContextUtils.producesDeclared(stmtContext2, declaredType)) continue;
            return stmtContext2;
        }
        return null;
    }

    public static final StmtContext<?, ?, ?> findFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, int startIndex, Class<? extends DeclaredStatement<?>> ... types) {
        if (startIndex >= types.length) {
            return null;
        }
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = stmtContext.declaredSubstatements();
        for (StmtContext stmtContext2 : declaredSubstatements) {
            if (!StmtContextUtils.producesDeclared(stmtContext2, types[startIndex])) continue;
            if (startIndex + 1 == types.length) {
                return stmtContext2;
            }
            return StmtContextUtils.findFirstDeclaredSubstatement(stmtContext2, ++startIndex, types);
        }
        return null;
    }

    public static final <DT extends DeclaredStatement<?>> StmtContext<?, ?, ?> findFirstDeclaredSubstatementOnSublevel(StmtContext<?, ?, ?> stmtContext, Class<DT> declaredType, int sublevel) {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = stmtContext.declaredSubstatements();
        for (StmtContext stmtContext2 : declaredSubstatements) {
            StmtContext<?, ?, ?> result;
            if (sublevel == 1 && StmtContextUtils.producesDeclared(stmtContext2, declaredType)) {
                return stmtContext2;
            }
            if (sublevel <= 1 || (result = StmtContextUtils.findFirstDeclaredSubstatementOnSublevel(stmtContext2, declaredType, --sublevel)) == null) continue;
            return result;
        }
        return null;
    }

    public static final <DT extends DeclaredStatement<?>> StmtContext<?, ?, ?> findDeepFirstDeclaredSubstatement(StmtContext<?, ?, ?> stmtContext, Class<DT> declaredType) {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = stmtContext.declaredSubstatements();
        for (StmtContext stmtContext2 : declaredSubstatements) {
            if (StmtContextUtils.producesDeclared(stmtContext2, declaredType)) {
                return stmtContext2;
            }
            StmtContext<?, ?, ?> result = StmtContextUtils.findDeepFirstDeclaredSubstatement(stmtContext2, declaredType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static final boolean producesDeclared(StmtContext<?, ?, ?> ctx, Class<? extends DeclaredStatement<?>> type) {
        return type.isAssignableFrom(ctx.getPublicDefinition().getDeclaredRepresentationClass());
    }
}

