/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public abstract class DeclarationInTextSource
implements StatementSourceReference {
    private final String source;

    DeclarationInTextSource(String source) {
        this.source = source;
    }

    public String getSourceName() {
        return this.source;
    }

    @Override
    public StatementSource getStatementSource() {
        return StatementSource.DECLARATION;
    }

    @Override
    public abstract String toString();

    public static final DeclarationInTextSource inSource(String sourceName) {
        return new InSource(sourceName);
    }

    public static final DeclarationInTextSource atLine(String sourceName, int line) {
        return new AtLine(sourceName, line);
    }

    public static final DeclarationInTextSource atPosition(String sourceName, int line, int position) {
        return new AtPosition(sourceName, line, position);
    }

    private static class AtPosition
    extends DeclarationInTextSource {
        private int line;
        private int character;

        public AtPosition(String source, int line, int character) {
            super(source);
            this.line = line;
            this.character = character;
        }

        @Override
        public String toString() {
            return String.format("%s:%d:%d", this.getSourceName(), this.line, this.character);
        }
    }

    private static class AtLine
    extends DeclarationInTextSource {
        private final int line;

        public AtLine(String source, int line) {
            super(source);
            this.line = line;
        }

        @Override
        public String toString() {
            return String.format("%s:%d", this.getSourceName(), this.line);
        }
    }

    private static class InSource
    extends DeclarationInTextSource {
        public InSource(String source) {
            super(source);
        }

        @Override
        public String toString() {
            return this.getSourceName();
        }
    }
}

