/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceNotAvailableException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.meta.SomeModifiersUnresolvedException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveModelContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.EffectiveSchemaContext;

class BuildGlobalContext
extends NamespaceStorageSupport
implements NamespaceBehaviour.Registry {
    private static final List<ModelProcessingPhase> PHASE_EXECUTION_ORDER = ImmutableList.builder().add((Object)ModelProcessingPhase.SOURCE_LINKAGE).add((Object)ModelProcessingPhase.STATEMENT_DEFINITION).add((Object)ModelProcessingPhase.FULL_DECLARATION).add((Object)ModelProcessingPhase.EFFECTIVE_MODEL).build();
    private final Map<QName, StatementDefinitionContext<?, ?, ?>> definitions = new HashMap();
    private final Map<Class<?>, NamespaceBehaviourWithListeners<?, ?, ?>> namespaces = new HashMap();
    private final Map<ModelProcessingPhase, StatementSupportBundle> supports;
    private final Set<SourceSpecificContext> sources = new HashSet<SourceSpecificContext>();
    private ModelProcessingPhase currentPhase;
    private ModelProcessingPhase finishedPhase;

    public BuildGlobalContext(Map<ModelProcessingPhase, StatementSupportBundle> supports) {
        this.supports = supports;
    }

    public StatementSupportBundle getSupportsForPhase(ModelProcessingPhase currentPhase) {
        return this.supports.get((Object)currentPhase);
    }

    public void addSource(@Nonnull StatementStreamSource source) {
        this.sources.add(new SourceSpecificContext(this, source));
    }

    @Override
    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.GLOBAL;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return null;
    }

    @Override
    public NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviourWithListeners<K, V, N> getNamespaceBehaviour(Class<N> type) {
        NamespaceBehaviour potentialRaw;
        NamespaceBehaviourWithListeners<Object, Object, Object> potential = this.namespaces.get(type);
        if (potential == null && (potentialRaw = this.supports.get((Object)this.currentPhase).getNamespaceBehaviour(type)) != null) {
            potential = new NamespaceBehaviourWithListeners(potentialRaw);
            this.namespaces.put(type, potential);
        }
        if (potential != null) {
            Preconditions.checkState((boolean)type.equals(potential.getIdentifier()));
            return potential;
        }
        throw new NamespaceNotAvailableException("Namespace " + type + "is not available in phase " + (Object)((Object)this.currentPhase));
    }

    public StatementDefinitionContext<?, ?, ?> getStatementDefinition(QName name) {
        StatementSupport<?, ?, ?> potentialRaw;
        StatementDefinitionContext<?, ?, ?> potential = this.definitions.get(name);
        if (potential == null && (potentialRaw = this.supports.get((Object)this.currentPhase).getStatementDefinition(name)) != null) {
            potential = new StatementDefinitionContext(potentialRaw);
            this.definitions.put(name, potential);
        }
        return potential;
    }

    public EffectiveModelContext build() throws SourceException, ReactorException {
        for (ModelProcessingPhase phase : PHASE_EXECUTION_ORDER) {
            this.startPhase(phase);
            this.loadPhaseStatements();
            this.completePhaseActions();
            this.endPhase(phase);
        }
        return this.transform();
    }

    private EffectiveModelContext transform() {
        Preconditions.checkState((this.finishedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        ArrayList rootStatements = new ArrayList();
        for (SourceSpecificContext source : this.sources) {
            Object root = source.getRoot().buildDeclared();
            rootStatements.add((DeclaredStatement<?>)root);
        }
        return new EffectiveModelContext(rootStatements);
    }

    public EffectiveSchemaContext buildEffective() throws SourceException, ReactorException {
        for (ModelProcessingPhase phase : PHASE_EXECUTION_ORDER) {
            this.startPhase(phase);
            this.loadPhaseStatements();
            this.completePhaseActions();
            this.endPhase(phase);
        }
        return this.transformEffective();
    }

    private EffectiveSchemaContext transformEffective() {
        Preconditions.checkState((this.finishedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        ArrayList rootStatements = new ArrayList();
        ArrayList rootEffectiveStatements = new ArrayList();
        for (SourceSpecificContext source : this.sources) {
            Object root = source.getRoot().buildDeclared();
            rootStatements.add((DeclaredStatement<?>)root);
            Object rootEffective = source.getRoot().buildEffective();
            rootEffectiveStatements.add((EffectiveStatement<?, ?>)rootEffective);
        }
        return new EffectiveSchemaContext(rootStatements, rootEffectiveStatements);
    }

    private void startPhase(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)Objects.equals((Object)this.finishedPhase, (Object)phase.getPreviousPhase()));
        for (SourceSpecificContext source : this.sources) {
            source.startPhase(phase);
        }
        this.currentPhase = phase;
    }

    private void loadPhaseStatements() throws SourceException {
        Preconditions.checkState((this.currentPhase != null ? 1 : 0) != 0);
        for (SourceSpecificContext source : this.sources) {
            source.loadStatements();
        }
    }

    private void completePhaseActions() throws ReactorException {
        Preconditions.checkState((this.currentPhase != null ? 1 : 0) != 0);
        ArrayList sourcesToProgress = Lists.newArrayList(this.sources);
        try {
            boolean progressing = true;
            while (progressing) {
                progressing = false;
                Iterator currentSource = sourcesToProgress.iterator();
                while (currentSource.hasNext()) {
                    SourceSpecificContext.PhaseCompletionProgress sourceProgress = ((SourceSpecificContext)currentSource.next()).tryToCompletePhase(this.currentPhase);
                    switch (sourceProgress) {
                        case FINISHED: {
                            currentSource.remove();
                        }
                        case PROGRESS: {
                            progressing = true;
                        }
                    }
                }
            }
        }
        catch (SourceException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (!sourcesToProgress.isEmpty()) {
            SomeModifiersUnresolvedException buildFailure = new SomeModifiersUnresolvedException(this.currentPhase);
            for (SourceSpecificContext failedSource : sourcesToProgress) {
                SourceException sourceEx = failedSource.failModifiers(this.currentPhase);
                buildFailure.addSuppressed(sourceEx);
            }
            throw buildFailure;
        }
    }

    private void endPhase(ModelProcessingPhase phase) {
        Preconditions.checkState((this.currentPhase == phase ? 1 : 0) != 0);
        this.finishedPhase = this.currentPhase;
    }

    public Set<SourceSpecificContext> getSources() {
        return this.sources;
    }
}

