/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.BuildGlobalContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.EffectiveModelContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.EffectiveSchemaContext;

public class CrossSourceStatementReactor {
    private final Map<ModelProcessingPhase, StatementSupportBundle> supportedTerminology;

    CrossSourceStatementReactor(Map<ModelProcessingPhase, StatementSupportBundle> supportedTerminology) {
        this.supportedTerminology = ImmutableMap.copyOf(supportedTerminology);
    }

    public static final Builder builder() {
        return new Builder();
    }

    public final BuildAction newBuild() {
        return new BuildAction();
    }

    public class BuildAction {
        private final BuildGlobalContext context;

        public BuildAction() {
            this.context = new BuildGlobalContext(CrossSourceStatementReactor.this.supportedTerminology);
        }

        public void addSource(StatementStreamSource source) {
            this.context.addSource(source);
        }

        public EffectiveModelContext build() throws SourceException, ReactorException {
            return this.context.build();
        }

        public EffectiveSchemaContext buildEffective() throws SourceException, ReactorException {
            return this.context.buildEffective();
        }
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<CrossSourceStatementReactor> {
        final Map<ModelProcessingPhase, StatementSupportBundle> bundles = new EnumMap<ModelProcessingPhase, StatementSupportBundle>(ModelProcessingPhase.class);

        public Builder setBundle(ModelProcessingPhase phase, StatementSupportBundle bundle) {
            this.bundles.put(phase, bundle);
            return this;
        }

        public CrossSourceStatementReactor build() {
            return new CrossSourceStatementReactor(this.bundles);
        }
    }
}

