/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

class ModifierImpl
implements ModelActionBuilder {
    private final ModelProcessingPhase phase;
    private final Set<AbstractPrerequisite<?>> unsatisfied = new HashSet();
    private final Set<AbstractPrerequisite<?>> mutations = new HashSet();
    private ModelActionBuilder.InferenceAction action;
    private boolean actionApplied = false;

    ModifierImpl(ModelProcessingPhase phase) {
        this.phase = (ModelProcessingPhase)((Object)Preconditions.checkNotNull((Object)((Object)phase)));
    }

    private <D> AbstractPrerequisite<D> addReq(AbstractPrerequisite<D> prereq) {
        this.unsatisfied.add(prereq);
        return prereq;
    }

    private <T> AbstractPrerequisite<T> addMutation(AbstractPrerequisite<T> mutation) {
        this.mutations.add(mutation);
        return mutation;
    }

    private void checkNotRegistered() {
        Preconditions.checkState((this.action == null ? 1 : 0) != 0, (Object)"Action was already registered.");
    }

    private IllegalStateException shouldNotHappenProbablyBug(SourceException e) {
        return new IllegalStateException("Source exception during registering prerequisite. This is probably bug.", e);
    }

    private void tryToResolve() throws InferenceException {
        if (this.action == null) {
            return;
        }
        if (this.removeSatisfied()) {
            this.applyAction();
        }
    }

    private boolean removeSatisfied() {
        Iterator<AbstractPrerequisite<?>> prereq = this.unsatisfied.iterator();
        boolean allSatisfied = true;
        while (prereq.hasNext()) {
            if (prereq.next().isDone()) {
                prereq.remove();
                continue;
            }
            allSatisfied = false;
        }
        return allSatisfied;
    }

    ModelProcessingPhase getPhase() {
        return this.phase;
    }

    boolean isApplied() {
        return this.actionApplied;
    }

    void failModifier() throws InferenceException {
        this.removeSatisfied();
        this.action.prerequisiteFailed(this.unsatisfied);
        this.action = null;
    }

    private void applyAction() throws InferenceException {
        this.action.apply();
        this.actionApplied = true;
    }

    private <K, C extends StmtContext<?, ?, ?>, N extends StatementNamespace<K, ?, ?>> AbstractPrerequisite<C> requiresCtxImpl(StmtContext<?, ?, ?> context, Class<N> namespace, K key, ModelProcessingPhase phase) {
        this.checkNotRegistered();
        try {
            AddedToNamespace addedToNs = new AddedToNamespace(phase);
            this.addReq(addedToNs);
            ModifierImpl.contextImpl(context).onNamespaceItemAddedAction(namespace, key, addedToNs);
            return addedToNs;
        }
        catch (SourceException e) {
            throw this.shouldNotHappenProbablyBug(e);
        }
    }

    private <C extends StmtContext<?, ?, ?>> AbstractPrerequisite<C> requiresCtxImpl(C context, ModelProcessingPhase phase) {
        Preconditions.checkState((this.action == null ? 1 : 0) != 0, (Object)"Action was already registered.");
        try {
            PhaseFinished phaseFin = new PhaseFinished();
            this.addReq(phaseFin);
            ModifierImpl.contextImpl(context).addPhaseCompletedListener(phase, phaseFin);
            return phaseFin;
        }
        catch (SourceException e) {
            throw this.shouldNotHappenProbablyBug(e);
        }
    }

    private <K, C extends StmtContext.Mutable<?, ?, ?>, N extends StatementNamespace<K, ?, ?>> AbstractPrerequisite<C> mutatesCtxImpl(StmtContext<?, ?, ?> context, Class<N> namespace, K key, ModelProcessingPhase phase) {
        try {
            PhaseModificationInNamespace mod = new PhaseModificationInNamespace(phase);
            this.addMutation(mod);
            ModifierImpl.contextImpl(context).onNamespaceItemAddedAction(namespace, key, mod);
            return mod;
        }
        catch (SourceException e) {
            throw this.shouldNotHappenProbablyBug(e);
        }
    }

    private static StatementContextBase<?, ?, ?> contextImpl(StmtContext<?, ?, ?> context) {
        Preconditions.checkArgument((boolean)(context instanceof StatementContextBase), (Object)"Supplied context was not provided by this reactor.");
        return (StatementContextBase)StatementContextBase.class.cast(context);
    }

    @Override
    public <C extends StmtContext.Mutable<?, ?, ?>, CT extends C> ModelActionBuilder.Prerequisite<C> mutatesCtx(CT context, ModelProcessingPhase phase) {
        try {
            return this.addMutation(new PhaseMutation(ModifierImpl.contextImpl(context), phase));
        }
        catch (InferenceException e) {
            throw this.shouldNotHappenProbablyBug(e);
        }
    }

    public <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> AbstractPrerequisite<StmtContext<A, D, E>> requiresCtx(StmtContext<A, D, E> context, ModelProcessingPhase phase) {
        return this.requiresCtxImpl(context, phase);
    }

    @Override
    public <K, N extends StatementNamespace<K, ?, ?>> ModelActionBuilder.Prerequisite<StmtContext<?, ?, ?>> requiresCtx(StmtContext<?, ?, ?> context, Class<N> namespace, K key, ModelProcessingPhase phase) {
        return this.requiresCtxImpl(context, namespace, key, phase);
    }

    @Override
    public <D extends DeclaredStatement<?>> ModelActionBuilder.Prerequisite<D> requiresDeclared(StmtContext<?, ? extends D, ?> context) {
        return this.requiresCtxImpl(context, ModelProcessingPhase.FULL_DECLARATION).transform(StmtContextUtils.buildDeclared());
    }

    public <K, D extends DeclaredStatement<?>, N extends StatementNamespace<K, ? extends D, ?>> AbstractPrerequisite<StmtContext<?, D, ?>> requiresDeclaredCtx(StmtContext<?, ?, ?> context, Class<N> namespace, K key) {
        return this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.FULL_DECLARATION);
    }

    @Override
    public <K, D extends DeclaredStatement<?>, N extends StatementNamespace<K, ? extends D, ?>> ModelActionBuilder.Prerequisite<D> requiresDeclared(StmtContext<?, ?, ?> context, Class<N> namespace, K key) {
        AbstractPrerequisite rawContext = this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.FULL_DECLARATION);
        return rawContext.transform(StmtContextUtils.buildDeclared());
    }

    @Override
    public <E extends EffectiveStatement<?, ?>> ModelActionBuilder.Prerequisite<E> requiresEffective(StmtContext<?, ?, ? extends E> stmt) {
        return this.requiresCtxImpl(stmt, ModelProcessingPhase.EFFECTIVE_MODEL).transform(StmtContextUtils.buildEffective());
    }

    public <K, E extends EffectiveStatement<?, ?>, N extends StatementNamespace<K, ?, ? extends E>> AbstractPrerequisite<StmtContext<?, ?, E>> requiresEffectiveCtx(StmtContext<?, ?, ?> context, Class<N> namespace, K key) {
        return this.requiresCtxImpl(ModifierImpl.contextImpl(context), namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL);
    }

    @Override
    public <K, E extends EffectiveStatement<?, ?>, N extends StatementNamespace<K, ?, ? extends E>> ModelActionBuilder.Prerequisite<E> requiresEffective(StmtContext<?, ?, ?> context, Class<N> namespace, K key) {
        AbstractPrerequisite rawContext = this.requiresCtxImpl(context, namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL);
        return rawContext.transform(StmtContextUtils.buildEffective());
    }

    @Override
    public <N extends IdentifierNamespace<?, ?>> ModelActionBuilder.Prerequisite<StmtContext.Mutable<?, ?, ?>> mutatesNs(StmtContext.Mutable<?, ?, ?> context, Class<N> namespace) {
        try {
            return this.addMutation(new NamespaceMutation<N>(ModifierImpl.contextImpl(context), namespace));
        }
        catch (SourceException e) {
            throw this.shouldNotHappenProbablyBug(e);
        }
    }

    @Override
    public <T extends StmtContext.Mutable<?, ?, ?>> ModelActionBuilder.Prerequisite<T> mutatesEffectiveCtx(T stmt) {
        return this.mutatesCtx(stmt, ModelProcessingPhase.EFFECTIVE_MODEL);
    }

    public <K, E extends EffectiveStatement<?, ?>, N extends StatementNamespace<K, ?, ? extends E>> AbstractPrerequisite<StmtContext.Mutable<?, ?, E>> mutatesEffectiveCtx(StmtContext<?, ?, ?> context, Class<N> namespace, K key) {
        return this.mutatesCtxImpl(context, namespace, key, ModelProcessingPhase.EFFECTIVE_MODEL);
    }

    @Override
    public void apply(ModelActionBuilder.InferenceAction action) throws InferenceException {
        this.action = (ModelActionBuilder.InferenceAction)Preconditions.checkNotNull((Object)action);
        this.tryToResolve();
    }

    private class PhaseModificationInNamespace<C extends StmtContext.Mutable<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnNamespaceItemAdded,
    StatementContextBase.ContextMutation {
        private final ModelProcessingPhase modPhase;

        public <K, N extends StatementNamespace<K, ?, ?>> PhaseModificationInNamespace(ModelProcessingPhase phase) throws SourceException {
            Preconditions.checkArgument((phase != null ? 1 : 0) != 0, (Object)"Model processing phase must not be null");
            this.modPhase = phase;
        }

        @Override
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> context, Class<?> namespace, Object key, Object value) throws SourceException {
            context.addMutation(this.modPhase, this);
            this.resolvePrereq(context);
        }

        @Override
        public boolean isFinished() {
            return ModifierImpl.this.isApplied();
        }
    }

    private class AddedToNamespace<C extends StmtContext<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnNamespaceItemAdded,
    StatementContextBase.OnPhaseFinished {
        private final ModelProcessingPhase phase;

        public <K, N extends StatementNamespace<K, ?, ?>> AddedToNamespace(ModelProcessingPhase phase) {
            this.phase = phase;
        }

        @Override
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> context, Class<?> namespace, Object key, Object value) throws SourceException {
            StatementContextBase targetContext = (StatementContextBase)value;
            targetContext.addPhaseCompletedListener(this.phase, this);
        }

        @Override
        public void phaseFinished(StatementContextBase<?, ?, ?> context, ModelProcessingPhase phase) throws SourceException {
            this.resolvePrereq(context);
        }
    }

    private class NamespaceMutation<N extends IdentifierNamespace<?, ?>>
    extends AbstractPrerequisite<StmtContext.Mutable<?, ?, ?>> {
        public NamespaceMutation(StatementContextBase<?, ?, ?> ctx, Class<N> namespace) throws InferenceException {
            this.resolvePrereq(ctx);
        }
    }

    private class PhaseFinished<C extends StmtContext<?, ?, ?>>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.OnPhaseFinished {
        private PhaseFinished() {
        }

        @Override
        public void phaseFinished(StatementContextBase<?, ?, ?> context, ModelProcessingPhase phase) throws SourceException {
            this.resolvePrereq(context);
        }
    }

    private class PhaseMutation<C>
    extends AbstractPrerequisite<C>
    implements StatementContextBase.ContextMutation {
        public PhaseMutation(StatementContextBase<?, ?, ?> context, ModelProcessingPhase phase) throws InferenceException {
            context.addMutation(phase, this);
            this.resolvePrereq(context);
        }

        @Override
        public boolean isFinished() {
            return ModifierImpl.this.isApplied();
        }
    }

    private abstract class AbstractPrerequisite<T>
    implements ModelActionBuilder.Prerequisite<T> {
        private T value;
        private boolean done = false;

        private AbstractPrerequisite() {
        }

        @Override
        public T get() {
            Preconditions.checkState((boolean)this.isDone());
            return this.value;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        protected void resolvePrereq(T value) throws InferenceException {
            Preconditions.checkState((!this.isDone() ? 1 : 0) != 0);
            this.value = value;
            this.done = true;
            ModifierImpl.this.tryToResolve();
        }

        protected <O> ModelActionBuilder.Prerequisite<O> transform(final Function<? super T, O> transformation) {
            return new ModelActionBuilder.Prerequisite<O>(){

                @Override
                public O get() {
                    return transformation.apply(AbstractPrerequisite.this.get());
                }

                @Override
                public boolean isDone() {
                    return AbstractPrerequisite.this.isDone();
                }
            };
        }
    }
}

