/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;

final class NamespaceBehaviourWithListeners<K, V, N extends IdentifierNamespace<K, V>>
extends NamespaceBehaviour<K, V, N> {
    private final NamespaceBehaviour<K, V, N> delegate;
    private final Multimap<K, ValueAddedListener> listeners = HashMultimap.create();

    protected NamespaceBehaviourWithListeners(NamespaceBehaviour<K, V, N> delegate) {
        super(delegate.getIdentifier());
        this.delegate = delegate;
    }

    @Override
    public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, K key, V value) {
        this.delegate.addTo(storage, key, value);
        Iterator keyListeners = this.listeners.get(key).iterator();
        while (keyListeners.hasNext()) {
            ValueAddedListener listener = (ValueAddedListener)keyListeners.next();
            if (listener.ctxNode != storage && !this.hasIdentiticalValue(listener.ctxNode, key, value)) continue;
            keyListeners.remove();
            listener.onValueAdded(key, value);
        }
    }

    private boolean hasIdentiticalValue(NamespaceBehaviour.NamespaceStorageNode ctxNode, K key, V value) {
        return this.getFrom(ctxNode, key) == value;
    }

    void addValueListener(K key, ValueAddedListener listener) {
        this.listeners.put(key, (Object)listener);
    }

    @Override
    public V getFrom(NamespaceBehaviour.NamespaceStorageNode storage, K key) {
        return this.delegate.getFrom(storage, key);
    }

    static abstract class ValueAddedListener {
        private NamespaceBehaviour.NamespaceStorageNode ctxNode;

        public ValueAddedListener(NamespaceBehaviour.NamespaceStorageNode contextNode) {
            this.ctxNode = contextNode;
        }

        abstract void onValueAdded(Object var1, Object var2);
    }
}

