/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceNotAvailableException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class NamespaceStorageSupport
implements NamespaceBehaviour.NamespaceStorageNode {
    private final Map<Class<?>, Map<?, ?>> namespaces = new HashMap();

    NamespaceStorageSupport() {
    }

    @Override
    public abstract NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage();

    public abstract NamespaceBehaviour.Registry getBehaviourRegistry();

    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> V getFromNamespace(Class<N> type, K key) throws NamespaceNotAvailableException {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom(this, key);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<?, ?> getAllFromNamespace(Class<N> type) {
        return this.namespaces.get(type);
    }

    public final <K, V, VT extends V, N extends IdentifierNamespace<K, V>> void addToNs(Class<N> type, K key, VT value) throws NamespaceNotAvailableException {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo(this, key, value);
    }

    public final <K, N extends StatementNamespace<K, ?, ?>> void addContextToNamespace(Class<N> type, K key, StmtContext<?, ?, ?> value) throws NamespaceNotAvailableException {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo(this, key, value);
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        if (localNamespace != null) {
            return (V)localNamespace.get(key);
        }
        return null;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> void addToLocalStorage(Class<N> type, K key, V value) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        if (localNamespace == null) {
            this.checkLocalNamespaceAllowed(type);
            localNamespace = new HashMap();
            this.namespaces.put(type, localNamespace);
        }
        localNamespace.put(key, value);
        this.onNamespaceElementAdded(type, key, value);
    }
}

