/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

class RootStatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E> {
    private final SourceSpecificContext sourceContext;
    private final A argument;

    RootStatementContext(StatementContextBase.ContextBuilder<A, D, E> builder, SourceSpecificContext sourceContext) throws SourceException {
        super(builder);
        this.sourceContext = sourceContext;
        this.argument = builder.getDefinition().parseArgumentValue(this, builder.getRawArgument());
    }

    RootStatementContext(RootStatementContext<A, D, E> original, QNameModule newQNameModule) throws SourceException {
        super(original);
        this.sourceContext = original.sourceContext;
        this.argument = original.argument;
        this.copyDeclaredStmts(original, newQNameModule);
        this.copyEffectiveStmts(original, newQNameModule);
    }

    private void copyDeclaredStmts(RootStatementContext<A, D, E> original, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> originalDeclaredSubstatements = original.declaredSubstatements();
        for (StmtContext stmtContext : originalDeclaredSubstatements) {
            this.addEffectiveSubstatement(stmtContext.createCopy(newQNameModule, this));
        }
    }

    private void copyEffectiveStmts(RootStatementContext<A, D, E> original, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> originalEffectiveSubstatements = original.effectiveSubstatements();
        for (StmtContext stmtContext : originalEffectiveSubstatements) {
            this.addEffectiveSubstatement(stmtContext.createCopy(newQNameModule, this));
        }
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return null;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.sourceContext;
    }

    @Override
    public NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this.sourceContext;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this;
    }

    SourceSpecificContext getSourceContext() {
        return this.sourceContext;
    }

    @Override
    public A getStatementArgument() {
        return this.argument;
    }

    @Override
    public StatementContextBase<A, D, E> createCopy(QNameModule newQNameModule, StatementContextBase<?, ?, ?> newParent) throws SourceException {
        return new RootStatementContext<A, D, E>(this, newQNameModule);
    }

    @Override
    public List<Object> getArgumentsFromRoot() {
        LinkedList<Object> argumentList = new LinkedList<Object>();
        argumentList.add(this.argument);
        return argumentList;
    }
}

