/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.spi.ExtensionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImportedNamespaceContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModuleMap;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinitionMap;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.BuildGlobalContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ModifierImpl;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.UnknownStatementImpl;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;

public class SourceSpecificContext
implements NamespaceBehaviour.NamespaceStorageNode,
NamespaceBehaviour.Registry,
Mutable {
    private final StatementStreamSource source;
    private final BuildGlobalContext currentContext;
    private final Collection<NamespaceBehaviour.NamespaceStorageNode> importedNamespaces = new ArrayList<NamespaceBehaviour.NamespaceStorageNode>();
    private final Multimap<ModelProcessingPhase, ModifierImpl> modifiers = HashMultimap.create();
    private RootStatementContext<?, ?, ?> root;
    private ModelProcessingPhase inProgressPhase;
    private ModelProcessingPhase finishedPhase;
    private QNameToStatementDefinitionMap qNameToStmtDefMap = new QNameToStatementDefinitionMap();
    private PrefixToModuleMap prefixToModuleMap = new PrefixToModuleMap();

    SourceSpecificContext(BuildGlobalContext currentContext, StatementStreamSource source) {
        this.source = source;
        this.currentContext = currentContext;
    }

    StatementDefinitionContext<?, ?, ?> getDefinition(QName name) {
        return this.currentContext.getStatementDefinition(name);
    }

    StatementContextBase.ContextBuilder<?, ?, ?> createDeclaredChild(StatementContextBase<?, ?, ?> current, QName name, StatementSourceReference ref) {
        StatementDefinitionContext<Object, Object, Object> def = this.getDefinition(name);
        if (def == null && Utils.isValidStatementDefinition(this.prefixToModuleMap, this.qNameToStmtDefMap, name)) {
            def = new StatementDefinitionContext<String, UnknownStatement<String>, EffectiveStatement<String, UnknownStatement<String>>>(new UnknownStatementImpl.Definition(this.qNameToStmtDefMap.get(Utils.trimPrefix(name))));
        }
        Preconditions.checkArgument((def != null ? 1 : 0) != 0, (String)"Statement %s does not have type mapping defined.", (Object[])new Object[]{name});
        if (current == null) {
            return this.createDeclaredRoot(def, ref);
        }
        return current.substatementBuilder(def, ref);
    }

    private StatementContextBase.ContextBuilder<?, ?, ?> createDeclaredRoot(StatementDefinitionContext<?, ?, ?> def, StatementSourceReference ref) {
        return new StatementContextBase.ContextBuilder(def, ref){

            public StatementContextBase build() throws SourceException {
                if (SourceSpecificContext.this.root == null) {
                    SourceSpecificContext.this.root = new RootStatementContext(this, SourceSpecificContext.this);
                } else {
                    Preconditions.checkState((boolean)SourceSpecificContext.this.root.getIdentifier().equals(this.getIdentifier()), (String)"Root statement was already defined as %s.", (Object[])new Object[]{SourceSpecificContext.this.root.getIdentifier()});
                }
                SourceSpecificContext.this.root.resetLists();
                return SourceSpecificContext.this.root;
            }
        };
    }

    RootStatementContext<?, ?, ?> getRoot() {
        return this.root;
    }

    DeclaredStatement<?> buildDeclared() {
        return this.root.buildDeclared();
    }

    EffectiveStatement<?, ?> buildEffective() {
        return this.root.buildEffective();
    }

    void startPhase(ModelProcessingPhase phase) {
        ModelProcessingPhase previousPhase = phase.getPreviousPhase();
        Preconditions.checkState((boolean)Objects.equals((Object)previousPhase, (Object)this.finishedPhase));
        Preconditions.checkState((boolean)this.modifiers.get((Object)previousPhase).isEmpty());
        this.inProgressPhase = phase;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> void addToLocalStorage(Class<N> type, K key, V value) {
        if (ImportedNamespaceContext.class.isAssignableFrom(type)) {
            this.importedNamespaces.add((NamespaceBehaviour.NamespaceStorageNode)value);
        }
        this.getRoot().addToLocalStorage((Class)type, (Object)key, (Object)value);
    }

    @Override
    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.SOURCE_LOCAL_SPECIAL;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Object potentialLocal = this.getRoot().getFromLocalStorage((Class)type, (Object)key);
        if (potentialLocal != null) {
            return (V)potentialLocal;
        }
        for (NamespaceBehaviour.NamespaceStorageNode importedSource : this.importedNamespaces) {
            Object potential = importedSource.getFromLocalStorage(type, key);
            if (potential == null) continue;
            return potential;
        }
        return null;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> type) {
        return this.currentContext.getNamespaceBehaviour((Class)type);
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.currentContext;
    }

    PhaseCompletionProgress tryToCompletePhase(ModelProcessingPhase phase) throws SourceException {
        Collection currentPhaseModifiers = this.modifiers.get((Object)phase);
        boolean hasProgressed = this.hasProgress(currentPhaseModifiers);
        boolean phaseCompleted = this.root.tryToCompletePhase(phase);
        hasProgressed = this.hasProgress(currentPhaseModifiers);
        if (phaseCompleted && currentPhaseModifiers.isEmpty()) {
            this.finishedPhase = phase;
            return PhaseCompletionProgress.FINISHED;
        }
        if (hasProgressed) {
            return PhaseCompletionProgress.PROGRESS;
        }
        return PhaseCompletionProgress.NO_PROGRESS;
    }

    private boolean hasProgress(Collection<ModifierImpl> currentPhaseModifiers) {
        Iterator<ModifierImpl> modifier = currentPhaseModifiers.iterator();
        boolean hasProgressed = false;
        while (modifier.hasNext()) {
            if (!modifier.next().isApplied()) continue;
            modifier.remove();
            hasProgressed = true;
        }
        return hasProgressed;
    }

    ModelActionBuilder newInferenceAction(ModelProcessingPhase phase) {
        ModifierImpl action = new ModifierImpl(phase);
        this.modifiers.put((Object)phase, (Object)action);
        return action;
    }

    public String toString() {
        return "SourceSpecificContext [source=" + this.source + ", current=" + (Object)((Object)this.inProgressPhase) + ", finished=" + (Object)((Object)this.finishedPhase) + "]";
    }

    SourceException failModifiers(ModelProcessingPhase identifier) {
        InferenceException sourceEx = new InferenceException("Fail to infer source relationships", this.root.getStatementSourceReference());
        for (ModifierImpl mod : this.modifiers.get((Object)identifier)) {
            try {
                mod.failModifier();
            }
            catch (SourceException e) {
                sourceEx.addSuppressed(e);
            }
        }
        return sourceEx;
    }

    void loadStatements() throws SourceException {
        switch (this.inProgressPhase) {
            case SOURCE_LINKAGE: {
                this.source.writeLinkage(new StatementContextWriter(this, this.inProgressPhase), this.stmtDef());
                break;
            }
            case STATEMENT_DEFINITION: {
                this.source.writeLinkageAndStatementDefinitions(new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes());
                break;
            }
            case FULL_DECLARATION: {
                this.source.writeFull(new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes());
                break;
            }
        }
    }

    private PrefixToModule prefixes() {
        Map<?, ?> prefixes = this.currentContext.getAllFromNamespace(PrefixToModule.class);
        for (Map.Entry<?, ?> prefix : prefixes.entrySet()) {
            this.prefixToModuleMap.put((String)prefix.getKey(), (QNameModule)prefix.getValue());
        }
        return this.prefixToModuleMap;
    }

    private QNameToStatementDefinition stmtDef() {
        Map<?, ?> extensions;
        ImmutableMap<QName, StatementSupport<?, ?, ?>> definitions = this.currentContext.getSupportsForPhase(this.inProgressPhase).getDefinitions();
        for (Map.Entry entry : definitions.entrySet()) {
            this.qNameToStmtDefMap.put((QName)entry.getKey(), (StatementDefinition)entry.getValue());
        }
        if (this.inProgressPhase.equals((Object)ModelProcessingPhase.FULL_DECLARATION) && (extensions = this.currentContext.getAllFromNamespace(ExtensionNamespace.class)) != null) {
            for (Map.Entry<?, ?> extension : extensions.entrySet()) {
                this.qNameToStmtDefMap.put(new QName(YangConstants.RFC6020_YIN_NAMESPACE, ((QName)extension.getKey()).getLocalName()), (StatementDefinition)((SubstatementContext)extension.getValue()).definition().getFactory());
            }
        }
        return this.qNameToStmtDefMap;
    }

    public static enum PhaseCompletionProgress {
        NO_PROGRESS,
        PROGRESS,
        FINISHED;

    }
}

