/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementIdentifier;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;

public abstract class StatementContextBase<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends NamespaceStorageSupport
implements StmtContext.Mutable<A, D, E>,
Identifiable<StatementIdentifier> {
    private final StatementDefinitionContext<A, D, E> definition;
    private final StatementIdentifier identifier;
    private final StatementSourceReference statementDeclSource;
    private Map<StatementIdentifier, StatementContextBase<?, ?, ?>> substatements = new LinkedHashMap();
    private Collection<StatementContextBase<?, ?, ?>> declared = new ArrayList();
    private Collection<StatementContextBase<?, ?, ?>> effective = new ArrayList();
    private ModelProcessingPhase completedPhase;
    private Multimap<ModelProcessingPhase, OnPhaseFinished> phaseListeners = HashMultimap.create();
    private Multimap<ModelProcessingPhase, ContextMutation> phaseMutation = HashMultimap.create();
    private D declaredInstance;
    private E effectiveInstance;

    StatementContextBase(@Nonnull ContextBuilder<A, D, E> builder) throws SourceException {
        this.definition = builder.getDefinition();
        this.identifier = builder.getIdentifier();
        this.statementDeclSource = builder.getStamementSource();
        this.completedPhase = null;
    }

    StatementContextBase(StatementContextBase<A, D, E> original) {
        this.definition = original.definition;
        this.identifier = original.identifier;
        this.statementDeclSource = original.statementDeclSource;
        this.completedPhase = null;
    }

    @Override
    public abstract StatementContextBase<?, ?, ?> getParentContext();

    @Override
    public abstract RootStatementContext<?, ?, ?> getRoot();

    public StatementIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public StatementSource getStatementSource() {
        return this.statementDeclSource.getStatementSource();
    }

    @Override
    public StatementSourceReference getStatementSourceReference() {
        return this.statementDeclSource;
    }

    @Override
    public String rawStatementArgument() {
        return this.identifier.getArgument();
    }

    @Override
    public Collection<StatementContextBase<?, ?, ?>> declaredSubstatements() {
        return Collections.unmodifiableCollection(this.declared);
    }

    @Override
    public Collection<StatementContextBase<?, ?, ?>> effectiveSubstatements() {
        return Collections.unmodifiableCollection(this.effective);
    }

    public void addEffectiveSubstatement(StatementContextBase<?, ?, ?> substatement) {
        this.effective.add(substatement);
    }

    public void addDeclaredSubstatement(StatementContextBase<?, ?, ?> substatement) {
        this.declared.add(substatement);
    }

    public ContextBuilder<?, ?, ?> substatementBuilder(StatementDefinitionContext<?, ?, ?> def, StatementSourceReference ref) {
        return new ContextBuilder(def, ref){

            public StatementContextBase build() throws SourceException {
                SubstatementContext potential = (SubstatementContext)StatementContextBase.this.substatements.get(this.getIdentifier());
                if (potential == null) {
                    potential = new SubstatementContext(StatementContextBase.this, this);
                    StatementContextBase.this.substatements.put(this.getIdentifier(), potential);
                }
                potential.resetLists();
                switch (this.getStamementSource().getStatementSource()) {
                    case DECLARATION: {
                        StatementContextBase.this.declared.add(potential);
                        break;
                    }
                    case CONTEXT: {
                        StatementContextBase.this.effective.add(potential);
                    }
                }
                return potential;
            }
        };
    }

    @Override
    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public D buildDeclared() {
        Preconditions.checkArgument((this.completedPhase == ModelProcessingPhase.FULL_DECLARATION || this.completedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        if (this.declaredInstance == null) {
            this.declaredInstance = this.definition().getFactory().createDeclared(this);
        }
        return this.declaredInstance;
    }

    @Override
    public E buildEffective() {
        Preconditions.checkArgument((this.completedPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0);
        if (this.effectiveInstance == null) {
            this.effectiveInstance = this.definition().getFactory().createEffective(this);
        }
        return this.effectiveInstance;
    }

    void resetLists() {
        this.declared.clear();
    }

    boolean tryToCompletePhase(ModelProcessingPhase phase) throws SourceException {
        if (phase.equals((Object)this.completedPhase)) {
            return true;
        }
        Iterator openMutations = this.phaseMutation.get((Object)phase).iterator();
        boolean finished = true;
        while (openMutations.hasNext()) {
            ContextMutation current = (ContextMutation)openMutations.next();
            if (current.isFinished()) {
                openMutations.remove();
                continue;
            }
            finished = false;
        }
        for (StatementContextBase<?, ?, ?> child : this.declared) {
            finished &= child.tryToCompletePhase(phase);
        }
        for (StatementContextBase<?, ?, ?> child : this.effective) {
            finished &= child.tryToCompletePhase(phase);
        }
        if (finished) {
            this.onPhaseCompleted(phase);
            return true;
        }
        return false;
    }

    private void onPhaseCompleted(ModelProcessingPhase phase) throws SourceException {
        this.completedPhase = phase;
        Iterator listener = this.phaseListeners.get((Object)this.completedPhase).iterator();
        while (listener.hasNext()) {
            ((OnPhaseFinished)listener.next()).phaseFinished(this, phase);
            listener.remove();
        }
    }

    void endDeclared(StatementSourceReference ref, ModelProcessingPhase phase) throws SourceException {
        this.definition().onDeclarationFinished(this, phase);
    }

    protected final StatementDefinitionContext<A, D, E> definition() {
        return this.definition;
    }

    @Override
    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
        this.definition().checkNamespaceAllowed(type);
    }

    @Override
    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceItemAddedAction(final Class<N> type, K key, final OnNamespaceItemAdded listener) throws SourceException {
        Object potential = this.getFromNamespace(type, key);
        if (potential != null) {
            listener.namespaceItemAdded(this, type, key, potential);
            return;
        }
        NamespaceBehaviour behaviour = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        if (behaviour instanceof NamespaceBehaviourWithListeners) {
            NamespaceBehaviourWithListeners casted = (NamespaceBehaviourWithListeners)behaviour;
            casted.addValueListener(key, new NamespaceBehaviourWithListeners.ValueAddedListener(this){

                @Override
                void onValueAdded(Object key, Object value) {
                    try {
                        listener.namespaceItemAdded(StatementContextBase.this, type, key, value);
                    }
                    catch (SourceException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public StatementDefinition getPublicDefinition() {
        return this.definition().getPublicView();
    }

    @Override
    public ModelActionBuilder newInferenceAction(ModelProcessingPhase phase) {
        return ((RootStatementContext)this.getRoot()).getSourceContext().newInferenceAction(phase);
    }

    void addPhaseCompletedListener(ModelProcessingPhase phase, OnPhaseFinished listener) throws SourceException {
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            if (!phase.equals((Object)finishedPhase)) continue;
            listener.phaseFinished(this, finishedPhase);
            return;
        }
        this.phaseListeners.put((Object)phase, (Object)listener);
    }

    void addMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            if (!phase.equals((Object)finishedPhase)) continue;
            throw new IllegalStateException("Mutation registered after phase was completed.");
        }
        this.phaseMutation.put((Object)phase, (Object)mutation);
    }

    @Override
    public <K, KT extends K, N extends StatementNamespace<K, ?, ?>> void addContext(Class<N> namespace, KT key, StmtContext<?, ?, ?> stmt) {
        this.addContextToNamespace(namespace, key, stmt);
    }

    static abstract class ContextBuilder<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
        private final StatementDefinitionContext<A, D, E> definition;
        private final StatementSourceReference stmtRef;
        private String rawArg;
        private StatementSourceReference argRef;

        public ContextBuilder(StatementDefinitionContext<A, D, E> def, StatementSourceReference sourceRef) {
            this.definition = def;
            this.stmtRef = sourceRef;
        }

        public void setArgument(@Nonnull String argument, @Nonnull StatementSourceReference argumentSource) {
            Preconditions.checkArgument((boolean)this.definition.hasArgument(), (Object)"Statement does not take argument.");
            this.rawArg = (String)Preconditions.checkNotNull((Object)argument);
            this.argRef = (StatementSourceReference)Preconditions.checkNotNull((Object)argumentSource);
        }

        public String getRawArgument() {
            return this.rawArg;
        }

        public StatementSourceReference getStamementSource() {
            return this.stmtRef;
        }

        public StatementSourceReference getArgumentSource() {
            return this.argRef;
        }

        public StatementDefinitionContext<A, D, E> getDefinition() {
            return this.definition;
        }

        public StatementIdentifier getIdentifier() {
            return new StatementIdentifier(this.definition.getStatementName(), this.rawArg);
        }

        public abstract StatementContextBase<A, D, E> build() throws SourceException;
    }

    static interface ContextMutation {
        public boolean isFinished();
    }

    static interface OnPhaseFinished
    extends EventListener {
        public void phaseFinished(StatementContextBase<?, ?, ?> var1, ModelProcessingPhase var2) throws SourceException;
    }

    static interface OnNamespaceItemAdded
    extends EventListener {
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> var1, Class<?> var2, Object var3, Object var4) throws SourceException;
    }
}

