/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

class StatementContextWriter
implements StatementWriter {
    private final SourceSpecificContext ctx;
    private StatementContextBase<?, ?, ?> parent;
    private StatementContextBase.ContextBuilder<?, ?, ?> current;
    private ModelProcessingPhase phase;

    public StatementContextWriter(SourceSpecificContext ctx, ModelProcessingPhase phase) {
        this.ctx = (SourceSpecificContext)Preconditions.checkNotNull((Object)ctx);
        this.phase = (ModelProcessingPhase)((Object)Preconditions.checkNotNull((Object)((Object)phase)));
    }

    @Override
    public void startStatement(QName name, StatementSourceReference ref) throws SourceException {
        this.defferedCreate();
        this.current = this.ctx.createDeclaredChild(this.parent, name, ref);
    }

    @Override
    public void argumentValue(String value, StatementSourceReference ref) {
        Preconditions.checkState((this.current != null ? 1 : 0) != 0, (Object)"Could not two arguments for one statement.");
        this.current.setArgument(value, ref);
    }

    void defferedCreate() throws SourceException {
        if (this.current != null) {
            this.parent = this.current.build();
            this.current = null;
        }
    }

    @Override
    public void endStatement(StatementSourceReference ref) throws SourceException {
        this.defferedCreate();
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0);
        this.parent.endDeclared(ref, this.phase);
        this.parent = this.parent.getParentContext();
    }
}

