/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public class StatementDefinitionContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
    private final StatementSupport<A, D, E> support;

    public StatementDefinitionContext(StatementSupport<A, D, E> support) {
        this.support = support;
    }

    public StatementFactory<A, D, E> getFactory() {
        return this.support;
    }

    public A parseArgumentValue(StmtContext<A, D, E> context, String value) throws SourceException {
        return this.support.parseArgumentValue(context, value);
    }

    public void checkNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> namespace) {
    }

    public StatementDefinition getPublicView() {
        return this.support.getPublicView();
    }

    public boolean onStatementAdded(StmtContext.Mutable<A, D, E> stmt) {
        return false;
    }

    public void onDeclarationFinished(StmtContext.Mutable<A, D, E> statement, ModelProcessingPhase phase) throws SourceException {
        switch (phase) {
            case SOURCE_LINKAGE: {
                this.support.onLinkageDeclared(statement);
                break;
            }
            case STATEMENT_DEFINITION: {
                this.support.onStatementDefinitionDeclared(statement);
                break;
            }
            case FULL_DECLARATION: {
                this.support.onFullDefinitionDeclared(statement);
                break;
            }
        }
    }

    public Class<?> getRepresentingClass() {
        return this.support.getDeclaredRepresentationClass();
    }

    public boolean hasArgument() {
        return this.support.getArgumentName() != null;
    }

    public QName getStatementName() {
        return this.support.getStatementName();
    }
}

