/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;

class StatementIdentifier {
    @Nonnull
    private final QName name;
    @Nullable
    private final String argument;

    StatementIdentifier(QName name, String argument) {
        this.name = (QName)Preconditions.checkNotNull((Object)name);
        this.argument = argument;
    }

    QName getName() {
        return this.name;
    }

    String getArgument() {
        return this.argument;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.argument == null ? 0 : this.argument.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementIdentifier other = (StatementIdentifier)obj;
        if (!this.name.equals((Object)other.name)) {
            return false;
        }
        return Objects.equal((Object)this.argument, (Object)other.argument);
    }

    public String toString() {
        return "StatementIdentifier [name=" + this.name + ", argument=" + this.argument + "]";
    }
}

