/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.GroupingUtils;

class SubstatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E> {
    private final StatementContextBase<?, ?, ?> parent;
    private final A argument;

    SubstatementContext(StatementContextBase<?, ?, ?> parent, StatementContextBase.ContextBuilder<A, D, E> builder) throws SourceException {
        super(builder);
        this.parent = (StatementContextBase)Preconditions.checkNotNull(parent, (Object)"Parent must not be null");
        this.argument = builder.getDefinition().parseArgumentValue(this, builder.getRawArgument());
    }

    SubstatementContext(SubstatementContext<A, D, E> original, QNameModule newQNameModule, StatementContextBase<?, ?, ?> newParent) throws SourceException {
        super(original);
        this.parent = newParent;
        if (newQNameModule != null && original.argument instanceof QName) {
            QName originalQName = (QName)original.argument;
            this.argument = QName.create((QNameModule)newQNameModule, (String)originalQName.getLocalName());
        } else {
            this.argument = original.argument;
        }
        this.copyDeclaredStmts(original, newQNameModule);
        this.copyEffectiveStmts(original, newQNameModule);
    }

    private void copyDeclaredStmts(SubstatementContext<A, D, E> original, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> originalDeclaredSubstatements = original.declaredSubstatements();
        for (StatementContextBase<?, ?, ?> stmtContext : originalDeclaredSubstatements) {
            if (GroupingUtils.needToCopyByUses(stmtContext)) {
                StatementContextBase<?, ?, ?> copy = stmtContext.createCopy(newQNameModule, this);
                this.addEffectiveSubstatement(copy);
                continue;
            }
            if (!GroupingUtils.isReusedByUses(stmtContext)) continue;
            this.addEffectiveSubstatement(stmtContext);
        }
    }

    private void copyEffectiveStmts(SubstatementContext<A, D, E> original, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> originalEffectiveSubstatements = original.effectiveSubstatements();
        for (StatementContextBase<?, ?, ?> stmtContext : originalEffectiveSubstatements) {
            if (GroupingUtils.needToCopyByUses(stmtContext)) {
                StatementContextBase<?, ?, ?> copy = stmtContext.createCopy(newQNameModule, this);
                this.addEffectiveSubstatement(copy);
                continue;
            }
            if (!GroupingUtils.isReusedByUses(stmtContext)) continue;
            this.addEffectiveSubstatement(stmtContext);
        }
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this.parent.getBehaviourRegistry();
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public A getStatementArgument() {
        return this.argument;
    }

    @Override
    public StatementContextBase<A, D, E> createCopy(QNameModule newQNameModule, StatementContextBase<?, ?, ?> newParent) throws SourceException {
        return new SubstatementContext<A, D, E>(this, newQNameModule, newParent);
    }

    @Override
    public List<Object> getArgumentsFromRoot() {
        List<Object> argumentsFromRoot = this.parent.getArgumentsFromRoot();
        argumentsFromRoot.add(this.argument);
        return argumentsFromRoot;
    }
}

