/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.parser.spi.NamespaceToModule;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.IncludedModuleContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;

public final class AugmentUtils {
    private static final String REGEX_PATH_REL1 = "\\.\\.?\\s*/(.+)";
    private static final String REGEX_PATH_REL2 = "//.*";

    private AugmentUtils() {
    }

    public static Iterable<QName> parseAugmentPath(StmtContext<?, ?, ?> ctx, String path) {
        if (path.matches(REGEX_PATH_REL1) || path.matches(REGEX_PATH_REL2)) {
            throw new IllegalArgumentException("An argument for augment can be only absolute path; or descendant if used in uses");
        }
        return Utils.parseXPath(ctx, path);
    }

    public static void copyFromSourceToTarget(StatementContextBase<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx) throws SourceException {
        QNameModule newQNameModule = AugmentUtils.getNewQNameModule(targetCtx, sourceCtx);
        AugmentUtils.copyDeclaredStmts(sourceCtx, targetCtx, newQNameModule);
        AugmentUtils.copyEffectiveStmts(sourceCtx, targetCtx, newQNameModule);
    }

    public static void copyDeclaredStmts(StatementContextBase<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = sourceCtx.declaredSubstatements();
        for (StatementContextBase<?, ?, ?> originalStmtCtx : declaredSubstatements) {
            if (AugmentUtils.needToCopyByAugment(originalStmtCtx)) {
                StatementContextBase<?, ?, ?> copy = originalStmtCtx.createCopy(newQNameModule, targetCtx);
                targetCtx.addEffectiveSubstatement(copy);
                continue;
            }
            if (!AugmentUtils.isReusedByAugment(originalStmtCtx)) continue;
            targetCtx.addEffectiveSubstatement(originalStmtCtx);
        }
    }

    public static void copyEffectiveStmts(StatementContextBase<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> effectiveSubstatements = sourceCtx.effectiveSubstatements();
        for (StatementContextBase<?, ?, ?> originalStmtCtx : effectiveSubstatements) {
            if (AugmentUtils.needToCopyByAugment(originalStmtCtx)) {
                StatementContextBase<?, ?, ?> copy = originalStmtCtx.createCopy(newQNameModule, targetCtx);
                targetCtx.addEffectiveSubstatement(copy);
                continue;
            }
            if (!AugmentUtils.isReusedByAugment(originalStmtCtx)) continue;
            targetCtx.addEffectiveSubstatement(originalStmtCtx);
        }
    }

    public static QNameModule getNewQNameModule(StatementContextBase<?, ?, ?> targetCtx, StatementContextBase<?, ?, ?> sourceCtx) {
        Object targetStmtArgument = targetCtx.getStatementArgument();
        StmtContext.Mutable root = sourceCtx.getRoot();
        String moduleName = (String)root.getStatementArgument();
        QNameModule sourceQNameModule = (QNameModule)((NamespaceStorageSupport)((Object)root)).getFromNamespace(ModuleNameToModuleQName.class, moduleName);
        if (targetStmtArgument instanceof QName) {
            QName targetQName = (QName)targetStmtArgument;
            QNameModule targetQNameModule = targetQName.getModule();
            if (targetQNameModule.equals((Object)sourceQNameModule)) {
                return null;
            }
            return targetQNameModule;
        }
        return null;
    }

    public static boolean needToCopyByAugment(StmtContext<?, ?, ?> stmtContext) {
        HashSet<Rfc6020Mapping> noCopyDefSet = new HashSet<Rfc6020Mapping>();
        noCopyDefSet.add(Rfc6020Mapping.USES);
        StatementDefinition def = stmtContext.getPublicDefinition();
        return !noCopyDefSet.contains(def);
    }

    public static boolean isReusedByAugment(StmtContext<?, ?, ?> stmtContext) {
        HashSet<Rfc6020Mapping> reusedDefSet = new HashSet<Rfc6020Mapping>();
        reusedDefSet.add(Rfc6020Mapping.TYPEDEF);
        StatementDefinition def = stmtContext.getPublicDefinition();
        return reusedDefSet.contains(def);
    }

    public static StatementContextBase<?, ?, ?> getAugmentTargetCtx(StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> augmentNode) {
        StatementContextBase rootStatementCtx;
        SchemaNodeIdentifier augmentTargetNode = (SchemaNodeIdentifier)augmentNode.getStatementArgument();
        LinkedList<StmtContext.Mutable> rootStatementCtxList = new LinkedList<StmtContext.Mutable>();
        if (augmentTargetNode.isAbsolute()) {
            if (augmentTargetNode == null) {
                throw new IllegalArgumentException("Augment argument null, something bad happened in some of previous parsing phases");
            }
            QNameModule module = ((QName)augmentTargetNode.getPathFromRoot().iterator().next()).getModule();
            StatementContextBase rootStatementCtx2 = (StatementContextBase)augmentNode.getFromNamespace(NamespaceToModule.class, module);
            rootStatementCtxList.add(rootStatementCtx2);
            Map<?, ?> subModules = rootStatementCtx2.getAllFromNamespace(IncludedModuleContext.class);
            if (subModules != null) {
                rootStatementCtxList.addAll(subModules.values());
            }
        } else {
            StatementContextBase parent = (StatementContextBase)augmentNode.getParentContext();
            if (StmtContextUtils.producesDeclared(parent, UsesStatement.class)) {
                rootStatementCtxList.add(parent.getParentContext());
            }
        }
        LinkedList<QName> augmentTargetPath = new LinkedList<QName>();
        augmentTargetPath.addAll((Collection)augmentTargetNode.getPathFromRoot());
        StatementContextBase<?, ?, ?> augmentTargetCtx = null;
        Iterator i$ = rootStatementCtxList.iterator();
        while (i$.hasNext() && (augmentTargetCtx = Utils.findCtxOfNodeInRoot(rootStatementCtx = (StatementContextBase)i$.next(), augmentTargetPath)) == null) {
        }
        if (augmentTargetCtx == null) {
            throw new NullPointerException(String.format("Augment path %s not found in target model so its resulting context is null", augmentNode.rawStatementArgument()));
        }
        return augmentTargetCtx;
    }
}

