/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import java.util.Collection;
import java.util.HashSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public final class GroupingUtils {
    private GroupingUtils() {
    }

    public static void copyFromSourceToTarget(StatementContextBase<?, ?, ?> sourceGrpStmtCtx, StatementContextBase<?, ?, ?> targetCtx) throws SourceException {
        QNameModule newQNameModule = GroupingUtils.getNewQNameModule(targetCtx, sourceGrpStmtCtx);
        GroupingUtils.copyDeclaredStmts(sourceGrpStmtCtx, targetCtx, newQNameModule);
        GroupingUtils.copyEffectiveStmts(sourceGrpStmtCtx, targetCtx, newQNameModule);
    }

    public static void copyDeclaredStmts(StatementContextBase<?, ?, ?> sourceGrpStmtCtx, StatementContextBase<?, ?, ?> targetCtx, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = sourceGrpStmtCtx.declaredSubstatements();
        for (StatementContextBase<?, ?, ?> originalStmtCtx : declaredSubstatements) {
            if (GroupingUtils.needToCopyByUses(originalStmtCtx)) {
                StatementContextBase<?, ?, ?> copy = originalStmtCtx.createCopy(newQNameModule, targetCtx);
                targetCtx.addEffectiveSubstatement(copy);
                continue;
            }
            if (!GroupingUtils.isReusedByUses(originalStmtCtx)) continue;
            targetCtx.addEffectiveSubstatement(originalStmtCtx);
        }
    }

    public static void copyEffectiveStmts(StatementContextBase<?, ?, ?> sourceGrpStmtCtx, StatementContextBase<?, ?, ?> targetCtx, QNameModule newQNameModule) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> effectiveSubstatements = sourceGrpStmtCtx.effectiveSubstatements();
        for (StatementContextBase<?, ?, ?> originalStmtCtx : effectiveSubstatements) {
            if (GroupingUtils.needToCopyByUses(originalStmtCtx)) {
                StatementContextBase<?, ?, ?> copy = originalStmtCtx.createCopy(newQNameModule, targetCtx);
                targetCtx.addEffectiveSubstatement(copy);
                continue;
            }
            if (!GroupingUtils.isReusedByUses(originalStmtCtx)) continue;
            targetCtx.addEffectiveSubstatement(originalStmtCtx);
        }
    }

    public static QNameModule getNewQNameModule(StatementContextBase<?, ?, ?> targetCtx, StmtContext<?, ?, ?> stmtContext) {
        if (GroupingUtils.needToCreateNewQName(stmtContext.getPublicDefinition())) {
            Object targetStmtArgument = targetCtx.getStatementArgument();
            Object sourceStmtArgument = stmtContext.getStatementArgument();
            if (targetStmtArgument instanceof QName && sourceStmtArgument instanceof QName) {
                QName sourceQName;
                QNameModule sourceQNameModule;
                QName targetQName = (QName)targetStmtArgument;
                QNameModule targetQNameModule = targetQName.getModule();
                if (targetQNameModule.equals((Object)(sourceQNameModule = (sourceQName = (QName)sourceStmtArgument).getModule()))) {
                    return null;
                }
                return targetQNameModule;
            }
            return null;
        }
        return null;
    }

    public static boolean needToCreateNewQName(StatementDefinition publicDefinition) {
        return true;
    }

    public static boolean needToCopyByUses(StmtContext<?, ?, ?> stmtContext) {
        HashSet<Rfc6020Mapping> noCopyDefSet = new HashSet<Rfc6020Mapping>();
        noCopyDefSet.add(Rfc6020Mapping.USES);
        StatementDefinition def = stmtContext.getPublicDefinition();
        return !noCopyDefSet.contains(def);
    }

    public static boolean isReusedByUses(StmtContext<?, ?, ?> stmtContext) {
        HashSet<Rfc6020Mapping> reusedDefSet = new HashSet<Rfc6020Mapping>();
        reusedDefSet.add(Rfc6020Mapping.TYPEDEF);
        StatementDefinition def = stmtContext.getPublicDefinition();
        return reusedDefSet.contains(def);
    }

    public static void resolveUsesNode(StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> usesNode, StatementContextBase<?, ?, ?> targetNodeStmtCtx) throws SourceException {
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = usesNode.declaredSubstatements();
        for (StatementContextBase<?, ?, ?> subStmtCtx : declaredSubstatements) {
            if (StmtContextUtils.producesDeclared(subStmtCtx, WhenStatement.class)) {
                StatementContextBase<?, ?, ?> copy = subStmtCtx.createCopy(null, targetNodeStmtCtx);
                targetNodeStmtCtx.addEffectiveSubstatement(copy);
            }
            if (StmtContextUtils.producesDeclared(subStmtCtx, RefineStatement.class)) {
                // empty if block
            }
            if (!StmtContextUtils.producesDeclared(subStmtCtx, AugmentStatement.class)) continue;
        }
    }
}

