/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.Optional;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleIdentifierImpl;
import org.opendaylight.yangtools.yang.parser.spi.ModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToModuleIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.ImportStatementImpl;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.ImportedModuleContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.ImportEffectiveStatementImpl;

public class ImportStatementDefinition
extends AbstractStatementSupport<String, ImportStatement, EffectiveStatement<String, ImportStatement>> {
    public ImportStatementDefinition() {
        super((StatementDefinition)Rfc6020Mapping.IMPORT);
    }

    @Override
    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    @Override
    public ImportStatement createDeclared(StmtContext<String, ImportStatement, ?> ctx) {
        return new ImportStatementImpl(ctx);
    }

    @Override
    public EffectiveStatement<String, ImportStatement> createEffective(StmtContext<String, ImportStatement, EffectiveStatement<String, ImportStatement>> ctx) {
        return new ImportEffectiveStatementImpl(ctx);
    }

    @Override
    public void onLinkageDeclared(final StmtContext.Mutable<String, ImportStatement, EffectiveStatement<String, ImportStatement>> stmt) throws SourceException {
        final ModuleIdentifier impIdentifier = ImportStatementDefinition.getImportedModuleIdentifier(stmt);
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite<StmtContext<EffectiveStatement<String, ImportStatement>, EffectiveStatement<String, ImportStatement>, EffectiveStatement<String, ImportStatement>>> imported = importAction.requiresCtx(stmt, ModuleNamespace.class, impIdentifier, ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite linkageTarget = importAction.mutatesCtx(stmt.getRoot(), ModelProcessingPhase.SOURCE_LINKAGE);
        String impPrefix = (String)StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), PrefixStatement.class);
        stmt.addToNs(ImpPrefixToModuleIdentifier.class, impPrefix, impIdentifier);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            @Override
            public void apply() throws InferenceException {
                StmtContext importedModule = (StmtContext)imported.get();
                ((StmtContext.Mutable)linkageTarget.get()).addToNs(ImportedModuleContext.class, impIdentifier, importedModule);
            }

            @Override
            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) throws InferenceException {
                if (failed.contains(imported)) {
                    throw new InferenceException("Imported module was not found.", stmt.getStatementSourceReference());
                }
            }
        });
    }

    private static ModuleIdentifier getImportedModuleIdentifier(StmtContext.Mutable<String, ImportStatement, ?> stmt) throws SourceException {
        Optional revision;
        String moduleName = (String)stmt.getStatementArgument();
        String revisionArg = (String)StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), RevisionDateStatement.class);
        if (revisionArg != null) {
            try {
                revision = Optional.of((Object)SimpleDateFormatUtil.getRevisionFormat().parse(revisionArg));
            }
            catch (ParseException e) {
                throw new SourceException(String.format("Revision value %s is not in required format yyyy-MM-dd", revisionArg), stmt.getStatementSourceReference(), e);
            }
        } else {
            revision = Optional.of((Object)SimpleDateFormatUtil.DEFAULT_DATE_IMP);
        }
        return new ModuleIdentifierImpl(moduleName, (Optional<URI>)Optional.absent(), (Optional<Date>)revision);
    }
}

