/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.Optional;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IncludeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleIdentifierImpl;
import org.opendaylight.yangtools.yang.parser.spi.SubmoduleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.IncludedModuleContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.IncludeEffectiveStatementImpl;

public class IncludeStatementImpl
extends AbstractDeclaredStatement<String>
implements IncludeStatement {
    protected IncludeStatementImpl(StmtContext<String, IncludeStatement, ?> context) {
        super(context);
    }

    public String getModule() {
        return (String)this.argument();
    }

    public PrefixStatement getPrefix() {
        return this.firstDeclared(PrefixStatement.class);
    }

    public RevisionDateStatement getRevisionDate() {
        return this.firstDeclared(RevisionDateStatement.class);
    }

    public static class Definition
    extends AbstractStatementSupport<String, IncludeStatement, EffectiveStatement<String, IncludeStatement>> {
        public Definition() {
            super((StatementDefinition)Rfc6020Mapping.INCLUDE);
        }

        @Override
        public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
            return value;
        }

        @Override
        public IncludeStatement createDeclared(StmtContext<String, IncludeStatement, ?> ctx) {
            return new IncludeStatementImpl(ctx);
        }

        @Override
        public EffectiveStatement<String, IncludeStatement> createEffective(StmtContext<String, IncludeStatement, EffectiveStatement<String, IncludeStatement>> ctx) {
            return new IncludeEffectiveStatementImpl(ctx);
        }

        @Override
        public void onLinkageDeclared(final StmtContext.Mutable<String, IncludeStatement, EffectiveStatement<String, IncludeStatement>> stmt) throws SourceException {
            final ModuleIdentifier includeSubmoduleIdentifier = Definition.getIncludeSubmoduleIdentifier(stmt);
            ModelActionBuilder includeAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
            final ModelActionBuilder.Prerequisite<StmtContext<EffectiveStatement<String, IncludeStatement>, EffectiveStatement<String, IncludeStatement>, EffectiveStatement<String, IncludeStatement>>> requiresCtxPrerequisite = includeAction.requiresCtx(stmt, SubmoduleNamespace.class, includeSubmoduleIdentifier, ModelProcessingPhase.SOURCE_LINKAGE);
            final ModelActionBuilder.Prerequisite mutatesCtxPrerequisite = includeAction.mutatesCtx(stmt.getRoot(), ModelProcessingPhase.SOURCE_LINKAGE);
            includeAction.apply(new ModelActionBuilder.InferenceAction(){

                @Override
                public void apply() throws InferenceException {
                    StmtContext includedSubmoduleStmt = (StmtContext)requiresCtxPrerequisite.get();
                    ((StmtContext.Mutable)mutatesCtxPrerequisite.get()).addToNs(IncludedModuleContext.class, includeSubmoduleIdentifier, includedSubmoduleStmt);
                }

                @Override
                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) throws InferenceException {
                    if (failed.contains(requiresCtxPrerequisite)) {
                        throw new InferenceException("Included submodule was not found.", stmt.getStatementSourceReference());
                    }
                }
            });
        }

        private static ModuleIdentifier getIncludeSubmoduleIdentifier(StmtContext.Mutable<String, IncludeStatement, ?> stmt) {
            Optional revision;
            String subModuleName = (String)stmt.getStatementArgument();
            String revisionArg = (String)StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), RevisionDateStatement.class);
            if (revisionArg != null) {
                try {
                    revision = Optional.of((Object)SimpleDateFormatUtil.getRevisionFormat().parse(revisionArg));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                revision = Optional.of((Object)SimpleDateFormatUtil.DEFAULT_DATE_IMP);
            }
            return new ModuleIdentifierImpl(subModuleName, (Optional<URI>)Optional.absent(), (Optional<Date>)revision);
        }
    }
}

