/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.KeyEffectiveStatementImpl;

public class KeyStatementImpl
extends AbstractDeclaredStatement<Collection<SchemaNodeIdentifier>>
implements KeyStatement {
    protected KeyStatementImpl(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, ?> context) {
        super(context);
    }

    public static class Definition
    extends AbstractStatementSupport<Collection<SchemaNodeIdentifier>, KeyStatement, EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement>> {
        public static final char SEPARATOR = ' ';

        public Definition() {
            super((StatementDefinition)Rfc6020Mapping.KEY);
        }

        @Override
        public Collection<SchemaNodeIdentifier> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) throws SourceException {
            Splitter keySplitter = Splitter.on((char)' ').omitEmptyStrings().trimResults();
            List keyTokens = keySplitter.splitToList((CharSequence)value);
            if (new HashSet(keyTokens).size() < keyTokens.size()) {
                throw new IllegalArgumentException();
            }
            HashSet<SchemaNodeIdentifier> keyNodes = new HashSet<SchemaNodeIdentifier>();
            for (String keyToken : keyTokens) {
                SchemaNodeIdentifier keyNode = SchemaNodeIdentifier.create((boolean)true, (QName[])new QName[]{Utils.qNameFromArgument(ctx, keyToken)});
                keyNodes.add(keyNode);
            }
            return keyNodes;
        }

        @Override
        public KeyStatement createDeclared(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, ?> ctx) {
            return new KeyStatementImpl(ctx);
        }

        @Override
        public EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement> createEffective(StmtContext<Collection<SchemaNodeIdentifier>, KeyStatement, EffectiveStatement<Collection<SchemaNodeIdentifier>, KeyStatement>> ctx) {
            return new KeyEffectiveStatementImpl(ctx);
        }
    }
}

