/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.Date;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleIdentifierImpl;
import org.opendaylight.yangtools.yang.parser.spi.ModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.NamespaceToModule;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToModuleIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleIdentifierToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleQNameToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.ModuleStatementImpl;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.ModuleEffectiveStatementImpl;

public class ModuleStatementSupport
extends AbstractStatementSupport<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> {
    private QNameModule qNameModule;

    public ModuleStatementSupport() {
        super((StatementDefinition)Rfc6020Mapping.MODULE);
    }

    @Override
    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    @Override
    public ModuleStatement createDeclared(StmtContext<String, ModuleStatement, ?> ctx) {
        return new ModuleStatementImpl(ctx);
    }

    @Override
    public EffectiveStatement<String, ModuleStatement> createEffective(StmtContext<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> ctx) {
        return new ModuleEffectiveStatementImpl(ctx);
    }

    @Override
    public void onLinkageDeclared(StmtContext.Mutable<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> stmt) throws SourceException {
        Optional moduleNs = Optional.fromNullable(StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), NamespaceStatement.class));
        if (!moduleNs.isPresent()) {
            throw new IllegalArgumentException("Namespace of the module [" + (String)stmt.getStatementArgument() + "] is missing.");
        }
        Optional revisionDate = Optional.fromNullable(StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), RevisionStatement.class));
        this.qNameModule = QNameModule.cachedReference((QNameModule)QNameModule.create((URI)((URI)moduleNs.get()), (Date)((Date)revisionDate.orNull())));
        ModuleIdentifierImpl moduleIdentifier = new ModuleIdentifierImpl((String)stmt.getStatementArgument(), (Optional<URI>)Optional.absent(), (Optional<Date>)revisionDate);
        stmt.addContext(ModuleNamespace.class, moduleIdentifier, stmt);
        stmt.addContext(NamespaceToModule.class, this.qNameModule, stmt);
        String modulePrefix = (String)StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), PrefixStatement.class);
        if (modulePrefix == null) {
            throw new IllegalArgumentException("Prefix of the module [" + (String)stmt.getStatementArgument() + "] is missing.");
        }
        stmt.addToNs(PrefixToModule.class, modulePrefix, this.qNameModule);
        stmt.addToNs(ModuleNameToModuleQName.class, stmt.getStatementArgument(), this.qNameModule);
        stmt.addToNs(ModuleQNameToModuleName.class, this.qNameModule, stmt.getStatementArgument());
        stmt.addToNs(ModuleIdentifierToModuleQName.class, moduleIdentifier, this.qNameModule);
        stmt.addToNs(ImpPrefixToModuleIdentifier.class, modulePrefix, moduleIdentifier);
    }

    @Override
    public void onFullDefinitionDeclared(StmtContext.Mutable<String, ModuleStatement, EffectiveStatement<String, ModuleStatement>> stmt) throws SourceException {
        stmt.addContext(NamespaceToModule.class, this.qNameModule, stmt);
    }
}

