/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import java.text.ParseException;
import java.util.Date;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.RevisionEffectiveStatementImpl;

public class RevisionStatementImpl
extends AbstractDeclaredStatement<Date>
implements RevisionStatement {
    protected RevisionStatementImpl(StmtContext<Date, RevisionStatement, ?> context) {
        super(context);
    }

    public Date getDate() {
        return (Date)this.argument();
    }

    @Nullable
    public DescriptionStatement getDescription() {
        return this.firstDeclared(DescriptionStatement.class);
    }

    @Nullable
    public ReferenceStatement getReference() {
        return this.firstDeclared(ReferenceStatement.class);
    }

    public static class Definition
    extends AbstractStatementSupport<Date, RevisionStatement, EffectiveStatement<Date, RevisionStatement>> {
        public Definition() {
            super((StatementDefinition)Rfc6020Mapping.REVISION);
        }

        @Override
        public Date parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) throws SourceException {
            Date revision;
            try {
                revision = SimpleDateFormatUtil.getRevisionFormat().parse(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
            return revision;
        }

        @Override
        public RevisionStatement createDeclared(StmtContext<Date, RevisionStatement, ?> ctx) {
            return new RevisionStatementImpl(ctx);
        }

        @Override
        public EffectiveStatement<Date, RevisionStatement> createEffective(StmtContext<Date, RevisionStatement, EffectiveStatement<Date, RevisionStatement>> ctx) {
            return new RevisionEffectiveStatementImpl(ctx);
        }
    }
}

