/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.Date;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleIdentifierImpl;
import org.opendaylight.yangtools.yang.parser.spi.SubmoduleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.AbstractRootStatement;

public class SubmoduleStatementImpl
extends AbstractRootStatement<SubmoduleStatement>
implements SubmoduleStatement {
    protected SubmoduleStatementImpl(StmtContext<String, SubmoduleStatement, ?> context) {
        super(context);
    }

    public String getName() {
        return this.rawArgument();
    }

    public YangVersionStatement getYangVersion() {
        return this.firstDeclared(YangVersionStatement.class);
    }

    public BelongsToStatement getBelongsTo() {
        return this.firstDeclared(BelongsToStatement.class);
    }

    public static class Definition
    extends AbstractStatementSupport<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> {
        public Definition() {
            super((StatementDefinition)Rfc6020Mapping.SUBMODULE);
        }

        @Override
        public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
            return value;
        }

        @Override
        public SubmoduleStatement createDeclared(StmtContext<String, SubmoduleStatement, ?> ctx) {
            return new SubmoduleStatementImpl(ctx);
        }

        @Override
        public EffectiveStatement<String, SubmoduleStatement> createEffective(StmtContext<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onLinkageDeclared(StmtContext.Mutable<String, SubmoduleStatement, EffectiveStatement<String, SubmoduleStatement>> stmt) throws SourceException {
            Optional revisionDate = Optional.fromNullable(StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), RevisionStatement.class));
            ModuleIdentifierImpl submoduleIdentifier = new ModuleIdentifierImpl((String)stmt.getStatementArgument(), (Optional<URI>)Optional.absent(), (Optional<Date>)revisionDate);
            stmt.addContext(SubmoduleNamespace.class, submoduleIdentifier, stmt);
            String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf(stmt.declaredSubstatements(), BelongsToStatement.class);
            StmtContext<?, ?, ?> prefixSubStmtCtx = StmtContextUtils.findFirstDeclaredSubstatement(stmt, 0, BelongsToStatement.class, PrefixStatement.class);
            if (prefixSubStmtCtx == null) {
                throw new IllegalArgumentException("Prefix of belongsTo statement is missing in submodule [" + (String)stmt.getStatementArgument() + "].");
            }
            String prefix = (String)prefixSubStmtCtx.getStatementArgument();
            stmt.addToNs(BelongsToPrefixToModuleName.class, prefix, belongsToModuleName);
        }
    }
}

