/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import java.util.Collection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IfFeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenStatement;
import org.opendaylight.yangtools.yang.parser.spi.GroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.GroupingUtils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.UsesEffectiveStatementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsesStatementImpl
extends AbstractDeclaredStatement<QName>
implements UsesStatement {
    private static final Logger LOG = LoggerFactory.getLogger(UsesStatementImpl.class);

    protected UsesStatementImpl(StmtContext<QName, UsesStatement, ?> context) {
        super(context);
    }

    public QName getName() {
        return (QName)this.argument();
    }

    public WhenStatement getWhenStatement() {
        return this.firstDeclared(WhenStatement.class);
    }

    public Collection<? extends IfFeatureStatement> getIfFeatures() {
        return this.allDeclared(IfFeatureStatement.class);
    }

    public StatusStatement getStatus() {
        return this.firstDeclared(StatusStatement.class);
    }

    public DescriptionStatement getDescription() {
        return this.firstDeclared(DescriptionStatement.class);
    }

    public ReferenceStatement getReference() {
        return this.firstDeclared(ReferenceStatement.class);
    }

    public Collection<? extends AugmentStatement> getAugments() {
        return this.allDeclared(AugmentStatement.class);
    }

    public Collection<? extends RefineStatement> getRefines() {
        return this.allDeclared(RefineStatement.class);
    }

    public static class Definition
    extends AbstractStatementSupport<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> {
        public Definition() {
            super((StatementDefinition)Rfc6020Mapping.USES);
        }

        @Override
        public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
            return Utils.qNameFromArgument(ctx, value);
        }

        @Override
        public void onFullDefinitionDeclared(final StmtContext.Mutable<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> usesNode) throws SourceException {
            ModelActionBuilder usesAction = usesNode.newInferenceAction(ModelProcessingPhase.FULL_DECLARATION);
            final QName groupingName = (QName)usesNode.getStatementArgument();
            final ModelActionBuilder.Prerequisite<StmtContext<EffectiveStatement<QName, UsesStatement>, EffectiveStatement<QName, UsesStatement>, EffectiveStatement<QName, UsesStatement>>> sourceGroupingPre = usesAction.requiresCtx(usesNode, GroupingNamespace.class, groupingName, ModelProcessingPhase.FULL_DECLARATION);
            final ModelActionBuilder.Prerequisite targetNodePre = usesAction.mutatesCtx(usesNode.getParentContext(), ModelProcessingPhase.FULL_DECLARATION);
            usesAction.apply(new ModelActionBuilder.InferenceAction(){

                @Override
                public void apply() throws InferenceException {
                    StatementContextBase targetNodeStmtCtx = (StatementContextBase)targetNodePre.get();
                    StatementContextBase sourceGrpStmtCtx = (StatementContextBase)sourceGroupingPre.get();
                    try {
                        GroupingUtils.copyFromSourceToTarget(sourceGrpStmtCtx, targetNodeStmtCtx);
                        GroupingUtils.resolveUsesNode(usesNode, targetNodeStmtCtx);
                    }
                    catch (SourceException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }

                @Override
                public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) throws InferenceException {
                    if (failed.contains(sourceGroupingPre)) {
                        throw new InferenceException("Grouping " + groupingName + " was not resolved.", usesNode.getStatementSourceReference());
                    }
                    throw new InferenceException("Unknown error occurred.", usesNode.getStatementSourceReference());
                }
            });
        }

        @Override
        public UsesStatement createDeclared(StmtContext<QName, UsesStatement, ?> ctx) {
            return new UsesStatementImpl(ctx);
        }

        @Override
        public EffectiveStatement<QName, UsesStatement> createEffective(StmtContext<QName, UsesStatement, EffectiveStatement<QName, UsesStatement>> ctx) {
            return new UsesEffectiveStatementImpl(ctx);
        }
    }
}

