/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToModuleIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleIdentifierToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final CharMatcher DOUBLE_QUOTE_MATCHER = CharMatcher.is((char)'\"');
    private static final CharMatcher SINGLE_QUOTE_MATCHER = CharMatcher.is((char)'\'');
    private static final char SEPARATOR_NODENAME = '/';
    private static final String REGEX_PATH_ABS = "/[^/].*";

    private Utils() {
    }

    public static List<String> splitPathToNodeNames(String path) {
        Splitter keySplitter = Splitter.on((char)'/').omitEmptyStrings().trimResults();
        return keySplitter.splitToList((CharSequence)path);
    }

    public static void validateXPath(String path) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            xPath.compile(path);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Argument is not valid XPath string", e);
        }
    }

    public static boolean isXPathAbsolute(String path) {
        Utils.validateXPath(path);
        return path.matches(REGEX_PATH_ABS);
    }

    public static QName trimPrefix(QName identifier) {
        String prefixedLocalName = identifier.getLocalName();
        String[] namesParts = prefixedLocalName.split(":");
        if (namesParts.length == 2) {
            String localName = namesParts[1];
            return QName.create((QNameModule)identifier.getModule(), (String)localName);
        }
        return identifier;
    }

    public static boolean isValidStatementDefinition(PrefixToModule prefixes, QNameToStatementDefinition stmtDef, QName identifier) {
        if (stmtDef.get(identifier) != null) {
            return true;
        }
        String prefixedLocalName = identifier.getLocalName();
        String[] namesParts = prefixedLocalName.split(":");
        if (namesParts.length == 2) {
            String prefix = namesParts[0];
            String localName = namesParts[1];
            if (prefixes != null && prefixes.get(prefix) != null && stmtDef.get(new QName(YangConstants.RFC6020_YIN_NAMESPACE, localName)) != null) {
                return true;
            }
        }
        return false;
    }

    public static Iterable<QName> parseXPath(StmtContext<?, ?, ?> ctx, String path) {
        Utils.validateXPath(path);
        List<String> nodeNames = Utils.splitPathToNodeNames(path);
        ArrayList<QName> qNames = new ArrayList<QName>();
        for (String nodeName : nodeNames) {
            try {
                QName qName = Utils.qNameFromArgument(ctx, nodeName);
                qNames.add(qName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return qNames;
    }

    public static String stringFromStringContext(YangStatementParser.ArgumentContext context) {
        StringBuilder sb = new StringBuilder();
        List<TerminalNode> strings = context.STRING();
        if (strings.isEmpty()) {
            strings = Arrays.asList(context.IDENTIFIER());
        }
        for (TerminalNode stringNode : strings) {
            CharMatcher quoteMatcher;
            String str = stringNode.getText();
            char firstChar = str.charAt(0);
            if (SINGLE_QUOTE_MATCHER.matches(firstChar)) {
                quoteMatcher = SINGLE_QUOTE_MATCHER;
            } else if (DOUBLE_QUOTE_MATCHER.matches(firstChar)) {
                quoteMatcher = DOUBLE_QUOTE_MATCHER;
            } else {
                sb.append(str);
                continue;
            }
            sb.append(quoteMatcher.removeFrom((CharSequence)str.substring(1, str.length() - 1)));
        }
        return sb.toString();
    }

    public static QName qNameFromArgument(StmtContext<?, ?, ?> ctx, String value) {
        QNameModule qNameModule = null;
        try {
            qNameModule = QNameModule.create((URI)new URI(""), (Date)new Date(0L));
        }
        catch (URISyntaxException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        String localName = null;
        String[] namesParts = value.split(":");
        switch (namesParts.length) {
            case 1: {
                localName = namesParts[0];
                if (StmtContextUtils.producesDeclared(ctx.getRoot(), ModuleStatement.class)) {
                    String prefix = (String)StmtContextUtils.firstAttributeOf(ctx.getRoot().declaredSubstatements(), PrefixStatement.class);
                    qNameModule = (QNameModule)ctx.getFromNamespace(PrefixToModule.class, prefix);
                    break;
                }
                if (!StmtContextUtils.producesDeclared(ctx.getRoot(), SubmoduleStatement.class)) break;
                String belongsToModuleName = (String)StmtContextUtils.firstAttributeOf(ctx.getRoot().declaredSubstatements(), BelongsToStatement.class);
                qNameModule = (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, belongsToModuleName);
                break;
            }
            case 2: {
                String prefix = namesParts[0];
                localName = namesParts[1];
                ModuleIdentifier impModIdentifier = (ModuleIdentifier)ctx.getRoot().getFromNamespace(ImpPrefixToModuleIdentifier.class, prefix);
                qNameModule = (QNameModule)ctx.getFromNamespace(ModuleIdentifierToModuleQName.class, impModIdentifier);
                if (qNameModule != null || !StmtContextUtils.producesDeclared(ctx.getRoot(), SubmoduleStatement.class)) break;
                String moduleName = (String)ctx.getRoot().getFromNamespace(BelongsToPrefixToModuleName.class, prefix);
                qNameModule = (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, moduleName);
                break;
            }
        }
        return QName.create((QNameModule)qNameModule, localName);
    }

    @Nullable
    private static StatementContextBase<?, ?, ?> findCtxOfNodeInSubstatements(StatementContextBase<?, ?, ?> rootStmtCtx, Iterable<QName> path, boolean searchInEffective) {
        StatementContextBase<?, ?, ?> parent = rootStmtCtx;
        Iterator<QName> pathIter = path.iterator();
        QName targetNode = pathIter.next();
        while (pathIter.hasNext()) {
            for (StatementContextBase<?, ?, ?> child : searchInEffective ? parent.effectiveSubstatements() : parent.declaredSubstatements()) {
                if (!targetNode.equals(child.getStatementArgument())) continue;
                parent = child;
                targetNode = pathIter.next();
            }
            if (!parent.equals(rootStmtCtx)) continue;
            return null;
        }
        StatementContextBase<?, ?, ?> targetCtx = null;
        for (StatementContextBase<?, ?, ?> child : searchInEffective ? parent.effectiveSubstatements() : parent.declaredSubstatements()) {
            if (!targetNode.equals(child.getStatementArgument())) continue;
            targetCtx = child;
        }
        return targetCtx;
    }

    @Nullable
    public static StatementContextBase<?, ?, ?> findCtxOfNodeInRoot(StatementContextBase<?, ?, ?> rootStmtCtx, SchemaNodeIdentifier node) {
        System.out.println(node.getPathFromRoot());
        StatementContextBase<?, ?, ?> targetCtx = Utils.findCtxOfNodeInSubstatements(rootStmtCtx, node.getPathFromRoot(), false);
        if (targetCtx == null) {
            targetCtx = Utils.findCtxOfNodeInSubstatements(rootStmtCtx, node.getPathFromRoot(), true);
        }
        return targetCtx;
    }

    @Nullable
    public static StatementContextBase<?, ?, ?> findCtxOfNodeInRoot(StatementContextBase<?, ?, ?> rootStmtCtx, Iterable<QName> path) {
        StatementContextBase<?, ?, ?> targetCtx = Utils.findCtxOfNodeInSubstatements(rootStmtCtx, path, false);
        if (targetCtx == null) {
            targetCtx = Utils.findCtxOfNodeInSubstatements(rootStmtCtx, path, true);
        }
        return targetCtx;
    }

    public static SchemaPath getSchemaPath(StmtContext<?, ?, ?> ctx) {
        Iterator<Object> argumentsIterator = ctx.getArgumentsFromRoot().iterator();
        argumentsIterator.next();
        LinkedList<QName> qNamesFromRoot = new LinkedList<QName>();
        while (argumentsIterator.hasNext()) {
            Object argument = argumentsIterator.next();
            if (argument instanceof QName) {
                QName qname = (QName)argument;
                qNamesFromRoot.add(qname);
                continue;
            }
            return SchemaPath.SAME;
        }
        return SchemaPath.create(qNamesFromRoot, (boolean)true);
    }
}

