/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementLexer;
import org.opendaylight.yangtools.antlrv4.code.gen.YangStatementParser;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.impl.YangStatementParserListenerImpl;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangStatementSourceImpl
implements StatementStreamSource {
    private YangStatementParserListenerImpl yangStatementModelParser;
    private YangStatementParser.StatementContext statementContext;
    private ParseTreeWalker walker;
    private static final Logger LOG = LoggerFactory.getLogger(YangStatementSourceImpl.class);
    private static final StatementSourceReference REF = new StatementSourceReference(){

        @Override
        public StatementSource getStatementSource() {
            return StatementSource.DECLARATION;
        }
    };

    public YangStatementSourceImpl(String fileName) {
        try {
            this.statementContext = this.parseYangSource(this.loadFile(fileName));
            this.walker = new ParseTreeWalker();
            this.yangStatementModelParser = new YangStatementParserListenerImpl(REF);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeLinkage(StatementWriter writer, QNameToStatementDefinition stmtDef) throws SourceException {
        this.yangStatementModelParser.setAttributes(writer, stmtDef);
        this.walker.walk((ParseTreeListener)this.yangStatementModelParser, (ParseTree)this.statementContext);
    }

    @Override
    public void writeLinkageAndStatementDefinitions(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes) throws SourceException {
        this.yangStatementModelParser.setAttributes(writer, stmtDef, prefixes);
        this.walker.walk((ParseTreeListener)this.yangStatementModelParser, (ParseTree)this.statementContext);
    }

    @Override
    public void writeFull(StatementWriter writer, QNameToStatementDefinition stmtDef, PrefixToModule prefixes) throws SourceException {
        this.yangStatementModelParser.setAttributes(writer, stmtDef, prefixes);
        this.walker.walk((ParseTreeListener)this.yangStatementModelParser, (ParseTree)this.statementContext);
    }

    private FileInputStream loadFile(String fileName) throws URISyntaxException, FileNotFoundException {
        return new FileInputStream(new File(this.getClass().getResource(fileName).toURI()));
    }

    private YangStatementParser.StatementContext parseYangSource(InputStream stream) throws IOException, YangSyntaxErrorException {
        YangStatementLexer lexer = new YangStatementLexer((CharStream)new ANTLRInputStream(stream));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        YangStatementParser parser = new YangStatementParser((TokenStream)tokens);
        return parser.statement();
    }
}

