/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;

public abstract class AbstractEffectiveDocumentedDataNodeContainer<A, D extends DeclaredStatement<A>>
extends AbstractEffectiveDocumentedNode<A, D>
implements DataNodeContainer {
    private final ImmutableMap<QName, DataSchemaNode> childNodes;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;
    private final ImmutableSet<DataSchemaNode> publicChildNodes;

    protected AbstractEffectiveDocumentedDataNodeContainer(StmtContext<A, D, ?> ctx) {
        super(ctx);
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        HashMap<QName, DataSchemaNode> mutableChildNodes = new HashMap<QName, DataSchemaNode>();
        HashSet<GroupingDefinition> mutableGroupings = new HashSet<GroupingDefinition>();
        HashSet<UsesNode> mutableUses = new HashSet<UsesNode>();
        HashSet<TypeDefinition> mutableTypeDefinitions = new HashSet<TypeDefinition>();
        HashSet<DataSchemaNode> mutablePublicChildNodes = new HashSet<DataSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof DataSchemaNode) {
                DataSchemaNode dataSchemaNode = (DataSchemaNode)effectiveStatement;
                mutableChildNodes.put(dataSchemaNode.getQName(), dataSchemaNode);
                mutablePublicChildNodes.add(dataSchemaNode);
            }
            if (effectiveStatement instanceof UsesNode) {
                UsesNode usesNode = (UsesNode)effectiveStatement;
                mutableUses.add(usesNode);
            }
            if (effectiveStatement instanceof TypeDefinition) {
                TypeDefinition typeDef = (TypeDefinition)effectiveStatement;
                mutableTypeDefinitions.add(typeDef);
            }
            if (!(effectiveStatement instanceof GroupingDefinition)) continue;
            GroupingDefinition grp = (GroupingDefinition)effectiveStatement;
            mutableGroupings.add(grp);
        }
        this.childNodes = ImmutableMap.copyOf(mutableChildNodes);
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.publicChildNodes = ImmutableSet.copyOf(mutablePublicChildNodes);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Set<DataSchemaNode> getChildNodes() {
        return this.publicChildNodes;
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final DataSchemaNode getDataChildByName(QName name) {
        return (DataSchemaNode)this.childNodes.get((Object)name);
    }

    public final DataSchemaNode getDataChildByName(String name) {
        for (DataSchemaNode node : this.childNodes.values()) {
            if (!node.getQName().getLocalName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public Set<UsesNode> getUses() {
        return this.uses;
    }
}

