/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public abstract class AbstractEffectiveSchemaContext
implements SchemaContext {
    protected static final Supplier<NavigableSet<Module>> MODULE_SET_SUPPLIER = new Supplier<NavigableSet<Module>>(){

        public NavigableSet<Module> get() {
            return new TreeSet<Module>(REVISION_COMPARATOR);
        }
    };
    protected static final Comparator<Module> REVISION_COMPARATOR = new Comparator<Module>(){

        @Override
        public int compare(Module o1, Module o2) {
            if (o2.getRevision() == null) {
                return -1;
            }
            return o2.getRevision().compareTo(o1.getRevision());
        }
    };

    protected abstract Map<ModuleIdentifier, String> getIdentifiersToSources();

    protected abstract SetMultimap<URI, Module> getNamespaceToModules();

    protected abstract SetMultimap<String, Module> getNameToModules();

    public Set<DataSchemaNode> getDataDefinitions() {
        HashSet<DataSchemaNode> dataDefs = new HashSet<DataSchemaNode>();
        for (Module m : this.getModules()) {
            dataDefs.addAll(m.getChildNodes());
        }
        return dataDefs;
    }

    public Set<NotificationDefinition> getNotifications() {
        HashSet<NotificationDefinition> notifications = new HashSet<NotificationDefinition>();
        for (Module m : this.getModules()) {
            notifications.addAll(m.getNotifications());
        }
        return notifications;
    }

    public Set<RpcDefinition> getOperations() {
        HashSet<RpcDefinition> rpcs = new HashSet<RpcDefinition>();
        for (Module m : this.getModules()) {
            rpcs.addAll(m.getRpcs());
        }
        return rpcs;
    }

    public Set<ExtensionDefinition> getExtensions() {
        HashSet<ExtensionDefinition> extensions = new HashSet<ExtensionDefinition>();
        for (Module m : this.getModules()) {
            extensions.addAll(m.getExtensionSchemaNodes());
        }
        return extensions;
    }

    public Module findModuleByName(String name, Date revision) {
        for (Module module : this.getNameToModules().get((Object)name)) {
            if (revision != null && !revision.equals(module.getRevision())) continue;
            return module;
        }
        return null;
    }

    public Set<Module> findModuleByNamespace(URI namespace) {
        Set ret = this.getNamespaceToModules().get((Object)namespace);
        return ret == null ? Collections.emptySet() : ret;
    }

    public Module findModuleByNamespaceAndRevision(URI namespace, Date revision) {
        if (namespace == null) {
            return null;
        }
        for (Module module : this.findModuleByNamespace(namespace)) {
            if (revision != null && !revision.equals(module.getRevision())) continue;
            return module;
        }
        return null;
    }

    public boolean isAugmenting() {
        return false;
    }

    public boolean isAddedByUses() {
        return false;
    }

    public boolean isConfiguration() {
        return false;
    }

    public ConstraintDefinition getConstraints() {
        return null;
    }

    public QName getQName() {
        return SchemaContext.NAME;
    }

    public SchemaPath getPath() {
        return SchemaPath.ROOT;
    }

    public String getDescription() {
        return null;
    }

    public String getReference() {
        return null;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModules()) {
            result.addAll(module.getUnknownSchemaNodes());
        }
        return Collections.unmodifiableList(result);
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getTypeDefinitions());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<DataSchemaNode> getChildNodes() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getChildNodes());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<GroupingDefinition> getGroupings() {
        LinkedHashSet result = new LinkedHashSet();
        for (Module module : this.getModules()) {
            result.addAll(module.getGroupings());
        }
        return Collections.unmodifiableSet(result);
    }

    public DataSchemaNode getDataChildByName(QName name) {
        for (Module module : this.getModules()) {
            DataSchemaNode result = module.getDataChildByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public DataSchemaNode getDataChildByName(String name) {
        for (Module module : this.getModules()) {
            DataSchemaNode result = module.getDataChildByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Set<UsesNode> getUses() {
        return Collections.emptySet();
    }

    public boolean isPresenceContainer() {
        return false;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return Collections.emptySet();
    }

    public Set<ModuleIdentifier> getAllModuleIdentifiers() {
        return this.getIdentifiersToSources().keySet();
    }

    public Optional<String> getModuleSource(ModuleIdentifier moduleIdentifier) {
        String maybeSource = this.getIdentifiersToSources().get(moduleIdentifier);
        return Optional.fromNullable((Object)maybeSource);
    }
}

