/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.NamespaceRevisionAware;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedDataNodeContainer;

public class AugmentEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<SchemaNodeIdentifier, AugmentStatement>
implements AugmentationSchema,
NamespaceRevisionAware,
Comparable<AugmentEffectiveStatementImpl> {
    private final int order;
    private final SchemaPath targetPath;
    RevisionAwareXPath whenCondition;
    URI namespace;
    Date revision;
    ImmutableList<UnknownSchemaNode> unknownNodes;
    private AugmentationSchema copyOf;

    public AugmentEffectiveStatementImpl(StmtContext<SchemaNodeIdentifier, AugmentStatement, EffectiveStatement<SchemaNodeIdentifier, AugmentStatement>> ctx) {
        super(ctx);
        SchemaNodeIdentifier schemaNodeIdentifier = ctx.getStatementArgument();
        this.targetPath = SchemaPath.create((Iterable)schemaNodeIdentifier.getPathFromRoot(), (boolean)schemaNodeIdentifier.isAbsolute());
        this.order = 1;
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
            unknownNodesInit.add(unknownNode);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
    }

    public void setCopyOf(AugmentationSchema build) {
        this.copyOf = build;
    }

    public Optional<AugmentationSchema> getOriginalDefinition() {
        return Optional.fromNullable((Object)this.copyOf);
    }

    public SchemaPath getTargetPath() {
        return this.targetPath;
    }

    public RevisionAwareXPath getWhenCondition() {
        return this.whenCondition;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public Date getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int prime = 17;
        int result = 1;
        result = 17 * result + (this.targetPath == null ? 0 : this.targetPath.hashCode());
        result = 17 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
        result = 17 * result + this.getChildNodes().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AugmentEffectiveStatementImpl other = (AugmentEffectiveStatementImpl)obj;
        if (this.targetPath == null ? other.targetPath != null : !this.targetPath.equals((Object)other.targetPath)) {
            return false;
        }
        if (this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition)) {
            return false;
        }
        return this.getChildNodes().equals(other.getChildNodes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(AugmentEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("targetPath=").append(this.targetPath);
        sb.append(", when=").append(this.whenCondition);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(AugmentEffectiveStatementImpl o) {
        Preconditions.checkNotNull((Object)o);
        Iterator thisIt = this.targetPath.getPathFromRoot().iterator();
        Iterator otherIt = o.getTargetPath().getPathFromRoot().iterator();
        while (thisIt.hasNext()) {
            if (otherIt.hasNext()) {
                int comp = ((QName)thisIt.next()).compareTo((QName)otherIt.next());
                if (comp == 0) continue;
                return comp;
            }
            return 1;
        }
        if (otherIt.hasNext()) {
            return -1;
        }
        return this.order - o.order;
    }
}

