/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;

public class ChoiceEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, ChoiceStatement>
implements ChoiceSchemaNode,
DerivableSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    boolean augmenting;
    boolean addedByUses;
    ChoiceSchemaNode original;
    boolean configuration;
    ConstraintDefinition constraints;
    String defaultCase;
    ImmutableSet<ChoiceCaseNode> cases;
    ImmutableSet<AugmentationSchema> augmentations;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    public ChoiceEffectiveStatementImpl(StmtContext<QName, ChoiceStatement, EffectiveStatement<QName, ChoiceStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        HashSet<AugmentationSchema> augmentationsInit = new HashSet<AugmentationSchema>();
        HashSet<ChoiceCaseNode> casesInit = new HashSet<ChoiceCaseNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (effectiveStatement instanceof AugmentationSchema) {
                AugmentationSchema augmentationSchema = (AugmentationSchema)effectiveStatement;
                augmentationsInit.add(augmentationSchema);
            }
            if (!(effectiveStatement instanceof ChoiceCaseNode)) continue;
            ChoiceCaseNode choiceCaseNode = (ChoiceCaseNode)effectiveStatement;
            casesInit.add(choiceCaseNode);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
        this.cases = ImmutableSet.copyOf(casesInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public boolean isAugmenting() {
        return this.augmenting;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Optional<ChoiceSchemaNode> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public ConstraintDefinition getConstraints() {
        return this.constraints;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return this.augmentations;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public Set<ChoiceCaseNode> getCases() {
        return this.cases;
    }

    public ChoiceCaseNode getCaseNodeByName(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("Choice Case QName cannot be NULL!");
        }
        for (ChoiceCaseNode caseNode : this.cases) {
            if (caseNode == null || !name.equals((Object)caseNode.getQName())) continue;
            return caseNode;
        }
        return null;
    }

    public ChoiceCaseNode getCaseNodeByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Choice Case string Name cannot be NULL!");
        }
        for (ChoiceCaseNode caseNode : this.cases) {
            if (caseNode == null || caseNode.getQName() == null || !name.equals(caseNode.getQName().getLocalName())) continue;
            return caseNode;
        }
        return null;
    }

    public String getDefaultCase() {
        return this.defaultCase;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoiceEffectiveStatementImpl other = (ChoiceEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ChoiceEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("qname=").append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

