/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveSchemaContext;

public class EffectiveSchemaContext
extends AbstractEffectiveSchemaContext {
    private final Map<ModuleIdentifier, String> identifiersToSources;
    private final SetMultimap<URI, Module> namespaceToModules;
    private final SetMultimap<String, Module> nameToModules;
    private final Set<Module> modules;
    private final ImmutableList<DeclaredStatement<?>> rootDeclaredStatements;
    private final ImmutableList<EffectiveStatement<?, ?>> rootEffectiveStatements;

    public EffectiveSchemaContext(List<DeclaredStatement<?>> rootDeclaredStatements, List<EffectiveStatement<?, ?>> rootEffectiveStatements) {
        this.rootDeclaredStatements = ImmutableList.copyOf(rootDeclaredStatements);
        this.rootEffectiveStatements = ImmutableList.copyOf(rootEffectiveStatements);
        HashSet<Module> modulesInit = new HashSet<Module>();
        for (EffectiveStatement<?, ?> rootEffectiveStatement : rootEffectiveStatements) {
            if (!(rootEffectiveStatement instanceof Module)) continue;
            Module module = (Module)rootEffectiveStatement;
            modulesInit.add(module);
        }
        this.modules = ImmutableSet.copyOf(modulesInit);
        SetMultimap nsMap = Multimaps.newSetMultimap(new TreeMap(), (Supplier)MODULE_SET_SUPPLIER);
        SetMultimap nameMap = Multimaps.newSetMultimap(new TreeMap(), (Supplier)MODULE_SET_SUPPLIER);
        for (Module m : modulesInit) {
            nameMap.put((Object)m.getName(), (Object)m);
            nsMap.put((Object)m.getNamespace(), (Object)m);
        }
        this.namespaceToModules = ImmutableSetMultimap.copyOf((Multimap)nsMap);
        this.nameToModules = ImmutableSetMultimap.copyOf((Multimap)nameMap);
        this.identifiersToSources = null;
    }

    public ImmutableList<DeclaredStatement<?>> getRootDeclaredStatements() {
        return this.rootDeclaredStatements;
    }

    public ImmutableList<EffectiveStatement<?, ?>> getRootEffectiveStatements() {
        return this.rootEffectiveStatements;
    }

    @Override
    protected Map<ModuleIdentifier, String> getIdentifiersToSources() {
        return this.identifiersToSources;
    }

    public Set<Module> getModules() {
        return this.modules;
    }

    @Override
    protected SetMultimap<URI, Module> getNamespaceToModules() {
        return this.namespaceToModules;
    }

    @Override
    protected SetMultimap<String, Module> getNameToModules() {
        return this.nameToModules;
    }

    public String toString() {
        return String.format("SchemaContextImpl{modules=%s}", this.modules);
    }
}

