/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public abstract class EffectiveStatementBase<A, D extends DeclaredStatement<A>>
implements EffectiveStatement<A, D> {
    private final StmtContext<A, D, ?> stmtCtx;
    private final ImmutableList<? extends EffectiveStatement<?, ?>> substatements;
    private final StatementSource statementSource;
    private final StatementDefinition statementDefinition;
    private D declaredInstance;
    private final A argument;

    public EffectiveStatementBase(StmtContext<A, D, ?> ctx) {
        this.stmtCtx = ctx;
        this.statementDefinition = ctx.getPublicDefinition();
        this.argument = ctx.getStatementArgument();
        this.statementSource = ctx.getStatementSource();
        Collection<StatementContextBase<?, ?, ?>> declaredSubstatements = ctx.declaredSubstatements();
        Collection<StatementContextBase<?, ?, ?>> effectiveSubstatements = ctx.effectiveSubstatements();
        LinkedList substatementsInit = new LinkedList();
        substatementsInit.addAll(declaredSubstatements);
        substatementsInit.addAll(effectiveSubstatements);
        this.substatements = FluentIterable.from(substatementsInit).transform(StmtContextUtils.buildEffective()).toList();
    }

    public StatementDefinition statementDefinition() {
        return this.statementDefinition;
    }

    public A argument() {
        return this.argument;
    }

    public StatementSource getStatementSource() {
        return this.statementSource;
    }

    public D getDeclared() {
        if (this.declaredInstance == null) {
            this.declaredInstance = this.stmtCtx.buildDeclared();
        }
        return this.declaredInstance;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V get(Class<N> namespace, K identifier) {
        return this.stmtCtx.getFromNamespace(namespace, identifier);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
        return this.stmtCtx.getAllFromNamespace(namespace);
    }

    public Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return this.substatements;
    }

    public StmtContext<A, D, ?> getStatementContext() {
        return this.stmtCtx;
    }

    protected final <S extends EffectiveStatement<?, ?>> S firstEffective(Class<S> type) {
        EffectiveStatement result = null;
        try {
            result = (EffectiveStatement)type.cast(Iterables.find(this.substatements, (Predicate)Predicates.instanceOf(type)));
        }
        catch (NoSuchElementException e) {
            result = null;
        }
        return (S)result;
    }

    protected final <S extends EffectiveStatement<?, ?>> Collection<? extends S> allEffective(Class<S> type) {
        Collection<Object> result = null;
        try {
            result = (Collection)Collection.class.cast(Collections2.filter(this.substatements, (Predicate)Predicates.instanceOf(type)));
        }
        catch (NoSuchElementException e) {
            result = Collections.emptyList();
        }
        return result;
    }

    protected final <S extends SchemaNode> S firstSchemaNode(Class<S> type) {
        SchemaNode result = null;
        try {
            result = (SchemaNode)type.cast(Iterables.find(this.substatements, (Predicate)Predicates.instanceOf(type)));
        }
        catch (NoSuchElementException e) {
            result = null;
        }
        return (S)result;
    }

    protected final <S extends SchemaNode> Collection<? extends S> allSchemaNodes(Class<S> type) {
        Collection<Object> result = null;
        try {
            result = (Collection)Collection.class.cast(Collections2.filter(this.substatements, (Predicate)Predicates.instanceOf(type)));
        }
        catch (NoSuchElementException e) {
            result = Collections.emptyList();
        }
        return result;
    }
}

