/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ExtensionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.ArgumentEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.YinElementEffectiveStatementImpl;

public class ExtensionEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, ExtensionStatement>
implements ExtensionDefinition {
    private final QName qname;
    String argument;
    private final SchemaPath schemaPath;
    ImmutableList<UnknownSchemaNode> unknownNodes;
    boolean yin;

    public ExtensionEffectiveStatementImpl(StmtContext<QName, ExtensionStatement, EffectiveStatement<QName, ExtensionStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.schemaPath = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
        this.initFields();
    }

    private void initFields() {
        YinElementEffectiveStatementImpl yinElement;
        ArgumentEffectiveStatementImpl argumentSubstatement = this.firstEffective(ArgumentEffectiveStatementImpl.class);
        if (argumentSubstatement != null) {
            this.argument = ((QName)argumentSubstatement.argument()).getLocalName();
        }
        this.yin = (yinElement = this.firstEffective(YinElementEffectiveStatementImpl.class)) != null ? (Boolean)yinElement.argument() : false;
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
            unknownNodesInit.add(unknownNode);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.schemaPath;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public String getArgument() {
        return this.argument;
    }

    public boolean isYinElement() {
        return this.yin;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.schemaPath == null ? 0 : this.schemaPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionEffectiveStatementImpl other = (ExtensionEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.schemaPath == null ? other.schemaPath != null : !this.schemaPath.equals((Object)other.schemaPath));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ExtensionEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("argument=").append(this.argument);
        sb.append(", qname=").append(this.qname);
        sb.append(", schemaPath=").append(this.schemaPath);
        sb.append(", extensionSchemaNodes=").append(this.unknownNodes);
        sb.append(", yin=").append(this.yin);
        sb.append("]");
        return sb.toString();
    }
}

