/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedDataNodeContainer;

public class GroupingEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<QName, GroupingStatement>
implements GroupingDefinition {
    private final QName qname;
    private final SchemaPath path;
    private boolean addedByUses;
    private List<UnknownSchemaNode> unknownNodes;

    public GroupingEffectiveStatementImpl(StmtContext<QName, GroupingStatement, EffectiveStatement<QName, GroupingStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        this.unknownNodes = new LinkedList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
            this.unknownNodes.add(unknownNode);
        }
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupingEffectiveStatementImpl other = (GroupingEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(GroupingEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("qname=").append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

