/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;

public class IdentityEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, IdentityStatement>
implements IdentitySchemaNode {
    private final QName qname;
    private final SchemaPath path;
    IdentitySchemaNode baseIdentity;
    private final Set<IdentitySchemaNode> derivedIdentities;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    public IdentityEffectiveStatementImpl(StmtContext<QName, IdentityStatement, EffectiveStatement<QName, IdentityStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
        this.derivedIdentities = null;
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
            unknownNodesInit.add(unknownNode);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public IdentitySchemaNode getBaseIdentity() {
        return this.baseIdentity;
    }

    public Set<IdentitySchemaNode> getDerivedIdentities() {
        return Collections.unmodifiableSet(this.derivedIdentities);
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityEffectiveStatementImpl other = (IdentityEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(IdentityEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append("base=").append(this.baseIdentity);
        sb.append(", qname=").append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

