/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedNode;

public class LeafListEffectiveStatementImpl
extends AbstractEffectiveDocumentedNode<QName, LeafListStatement>
implements LeafListSchemaNode,
DerivableSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    boolean augmenting;
    boolean addedByUses;
    LeafListSchemaNode original;
    boolean configuration;
    ConstraintDefinition constraintsDef;
    TypeDefinition<?> type;
    boolean userOrdered;
    private ImmutableList<UnknownSchemaNode> unknownNodes;

    public LeafListEffectiveStatementImpl(StmtContext<QName, LeafListStatement, EffectiveStatement<QName, LeafListStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (!(effectiveStatement instanceof UnknownSchemaNode)) continue;
            UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
            unknownNodesInit.add(unknownNode);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public boolean isAugmenting() {
        return this.augmenting;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Optional<LeafListSchemaNode> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public ConstraintDefinition getConstraints() {
        return this.constraintsDef;
    }

    public TypeDefinition<?> getType() {
        return this.type;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeafListEffectiveStatementImpl other = (LeafListEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(LeafListEffectiveStatementImpl.class.getSimpleName());
        sb.append("[");
        sb.append(this.qname);
        sb.append("]");
        return sb.toString();
    }
}

