/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedDataNodeContainer;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.KeyEffectiveStatementImpl;

public class ListEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<QName, ListStatement>
implements ListSchemaNode,
DerivableSchemaNode {
    private final QName qname;
    private final SchemaPath path;
    boolean augmenting;
    boolean addedByUses;
    ListSchemaNode original;
    boolean configuration;
    ConstraintDefinition constraints;
    boolean userOrdered;
    ImmutableList<QName> keyDefinition;
    ImmutableSet<AugmentationSchema> augmentations;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    public ListEffectiveStatementImpl(StmtContext<QName, ListStatement, EffectiveStatement<QName, ListStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initKeyDefinition();
        this.initSubstatementCollections();
    }

    private void initKeyDefinition() {
        LinkedList<QName> keyDefinitionInit = new LinkedList<QName>();
        KeyEffectiveStatementImpl key = this.firstEffective(KeyEffectiveStatementImpl.class);
        if (key != null) {
            Collection keyParts = (Collection)key.argument();
            for (SchemaNodeIdentifier keyPart : keyParts) {
                keyDefinitionInit.add(keyPart.getLastComponent());
            }
        }
        this.keyDefinition = ImmutableList.copyOf(keyDefinitionInit);
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        HashSet<AugmentationSchema> augmentationsInit = new HashSet<AugmentationSchema>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (!(effectiveStatement instanceof AugmentationSchema)) continue;
            AugmentationSchema augmentationSchema = (AugmentationSchema)effectiveStatement;
            augmentationsInit.add(augmentationSchema);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public List<QName> getKeyDefinition() {
        return this.keyDefinition;
    }

    public boolean isAugmenting() {
        return this.augmenting;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public Optional<ListSchemaNode> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    public boolean isConfiguration() {
        return this.configuration;
    }

    public ConstraintDefinition getConstraints() {
        return this.constraints;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return this.augmentations;
    }

    public boolean isUserOrdered() {
        return this.userOrdered;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListEffectiveStatementImpl other = (ListEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        return "list " + this.qname.getLocalName();
    }
}

