/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.parser.builder.impl.ModuleImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedDataNodeContainer;

public class ModuleEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<String, ModuleStatement>
implements Module,
Immutable {
    private final QNameModule qnameModule;
    private final String name = (String)this.argument();
    private String sourcePath;
    private String prefix;
    private String yangVersion;
    private String organization;
    private String contact;
    private ImmutableSet<ModuleImport> imports;
    private ImmutableSet<Module> submodules;
    private ImmutableSet<FeatureDefinition> features;
    private ImmutableSet<NotificationDefinition> notifications;
    private ImmutableSet<AugmentationSchema> augmentations;
    private ImmutableSet<RpcDefinition> rpcs;
    private ImmutableSet<Deviation> deviations;
    private ImmutableList<ExtensionDefinition> extensionNodes;
    private ImmutableSet<IdentitySchemaNode> identities;
    private ImmutableList<UnknownSchemaNode> unknownNodes;
    private String source;

    public ModuleEffectiveStatementImpl(StmtContext<String, ModuleStatement, ?> ctx) {
        super(ctx);
        this.qnameModule = (QNameModule)ctx.getFromNamespace(ModuleNameToModuleQName.class, this.name);
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        HashSet<AugmentationSchema> augmentationsInit = new HashSet<AugmentationSchema>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (!(effectiveStatement instanceof AugmentationSchema)) continue;
            AugmentationSchema augmentationSchema = (AugmentationSchema)effectiveStatement;
            augmentationsInit.add(augmentationSchema);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
    }

    public String getModuleSourcePath() {
        return this.sourcePath;
    }

    public URI getNamespace() {
        return this.qnameModule.getNamespace();
    }

    public String getName() {
        return this.name;
    }

    public Date getRevision() {
        return this.qnameModule.getRevision();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getYangVersion() {
        return this.yangVersion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getContact() {
        return this.contact;
    }

    public Set<ModuleImport> getImports() {
        return this.imports;
    }

    public Set<Module> getSubmodules() {
        return this.submodules;
    }

    public Set<FeatureDefinition> getFeatures() {
        return this.features;
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.notifications;
    }

    public Set<AugmentationSchema> getAugmentations() {
        return this.augmentations;
    }

    public Set<RpcDefinition> getRpcs() {
        return this.rpcs;
    }

    public Set<Deviation> getDeviations() {
        return this.deviations;
    }

    public List<ExtensionDefinition> getExtensionSchemaNodes() {
        return this.extensionNodes;
    }

    public Set<IdentitySchemaNode> getIdentities() {
        return this.identities;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.yangVersion == null ? 0 : this.yangVersion.hashCode());
        result = 31 * result + this.qnameModule.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleEffectiveStatementImpl other = (ModuleEffectiveStatementImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!this.qnameModule.equals((Object)other.qnameModule)) {
            return false;
        }
        return !(this.yangVersion == null ? other.yangVersion != null : !this.yangVersion.equals(other.yangVersion));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ModuleImpl.class.getSimpleName());
        sb.append("[");
        sb.append("name=").append(this.name);
        sb.append(", namespace=").append(this.getNamespace());
        sb.append(", revision=").append(this.getRevision());
        sb.append(", prefix=").append(this.prefix);
        sb.append(", yangVersion=").append(this.yangVersion);
        sb.append("]");
        return sb.toString();
    }

    public QNameModule getQNameModule() {
        return this.qnameModule;
    }
}

