/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.Utils;
import org.opendaylight.yangtools.yang.parser.stmt.rfc6020.effective.AbstractEffectiveDocumentedDataNodeContainer;

public class NotificationEffectiveStatementImpl
extends AbstractEffectiveDocumentedDataNodeContainer<QName, NotificationStatement>
implements NotificationDefinition {
    private final QName qname;
    private final SchemaPath path;
    ImmutableSet<AugmentationSchema> augmentations;
    ImmutableList<UnknownSchemaNode> unknownNodes;

    public NotificationEffectiveStatementImpl(StmtContext<QName, NotificationStatement, EffectiveStatement<QName, NotificationStatement>> ctx) {
        super(ctx);
        this.qname = ctx.getStatementArgument();
        this.path = Utils.getSchemaPath(ctx);
        this.initSubstatementCollections();
    }

    private void initSubstatementCollections() {
        Collection<EffectiveStatement<?, ?>> effectiveSubstatements = this.effectiveSubstatements();
        LinkedList<UnknownSchemaNode> unknownNodesInit = new LinkedList<UnknownSchemaNode>();
        HashSet<AugmentationSchema> augmentationsInit = new HashSet<AugmentationSchema>();
        for (EffectiveStatement<?, ?> effectiveStatement : effectiveSubstatements) {
            if (effectiveStatement instanceof UnknownSchemaNode) {
                UnknownSchemaNode unknownNode = (UnknownSchemaNode)effectiveStatement;
                unknownNodesInit.add(unknownNode);
            }
            if (!(effectiveStatement instanceof AugmentationSchema)) continue;
            AugmentationSchema augmentationSchema = (AugmentationSchema)effectiveStatement;
            augmentationsInit.add(augmentationSchema);
        }
        this.unknownNodes = ImmutableList.copyOf(unknownNodesInit);
        this.augmentations = ImmutableSet.copyOf(augmentationsInit);
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public Set<AugmentationSchema> getAvailableAugmentations() {
        return this.augmentations;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownNodes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qname == null ? 0 : this.qname.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationEffectiveStatementImpl other = (NotificationEffectiveStatementImpl)obj;
        if (this.qname == null ? other.qname != null : !this.qname.equals((Object)other.qname)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(NotificationEffectiveStatementImpl.class.getSimpleName());
        sb.append("[qname=").append(this.qname).append(", path=").append(this.path).append("]");
        return sb.toString();
    }
}

